/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.mask;

import de.bluecolored.bluemap.core.map.mask.Mask;
import de.bluecolored.bluemap.core.util.Tristate;
import java.util.ArrayList;
import java.util.List;

public class CombinedMask
implements Mask {
    private final List<MaskLayer> layers = new ArrayList<MaskLayer>();

    public void add(Mask mask, boolean value) {
        if (!value && this.layers.isEmpty()) {
            this.layers.add(new MaskLayer(ALL, true));
        }
        this.layers.add(new MaskLayer(mask, value));
    }

    @Override
    public boolean test(int x, int y, int z) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            MaskLayer layer = this.layers.get(i);
            if (!layer.mask.test(x, y, z)) continue;
            return layer.value;
        }
        return this.layers.isEmpty();
    }

    @Override
    public Tristate test(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            MaskLayer layer = this.layers.get(i);
            Tristate result = layer.mask.test(minX, minY, minZ, maxX, maxY, maxZ);
            if (result == Tristate.FALSE) continue;
            if (result == Tristate.UNDEFINED) {
                return Tristate.UNDEFINED;
            }
            return Tristate.valueOf(layer.value);
        }
        return Tristate.valueOf(this.layers.isEmpty());
    }

    @Override
    public Mask submask(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        Tristate test = this.test(minX, minY, minZ, maxX, maxY, maxZ);
        if (test == Tristate.TRUE) {
            return ALL;
        }
        if (test == Tristate.FALSE) {
            return NONE;
        }
        CombinedMask optimized = new CombinedMask();
        for (MaskLayer layer : this.layers) {
            if (!optimized.layers.isEmpty() && layer.mask.test(minX, minY, minZ, maxX, maxY, maxZ) == Tristate.FALSE) continue;
            optimized.add(layer.mask.submask(minX, minY, minZ, maxX, maxY, maxZ), layer.value);
        }
        return optimized;
    }

    @Override
    public boolean isEdge(int minX, int minZ, int maxX, int maxZ) {
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            MaskLayer layer = this.layers.get(i);
            if (!layer.mask.isEdge(minX, minZ, maxX, maxZ)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.layers.size();
    }

    private record MaskLayer(Mask mask, boolean value) {
    }
}

