/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires.block;

import com.flowpowered.math.TrigMath;
import com.flowpowered.math.vector.Vector3f;
import com.flowpowered.math.vector.Vector3i;
import com.flowpowered.math.vector.Vector4f;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.map.hires.TileModelView;
import de.bluecolored.bluemap.core.map.hires.block.BlockRenderer;
import de.bluecolored.bluemap.core.resources.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.Variant;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Element;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Face;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.model.Model;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Direction;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;
import de.bluecolored.bluemap.core.util.math.VectorM2f;
import de.bluecolored.bluemap.core.util.math.VectorM3f;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;
import de.bluecolored.bluemap.core.world.block.ExtendedBlock;
import java.util.function.Function;

public class ResourceModelRenderer
implements BlockRenderer {
    private static final float BLOCK_SCALE = 0.0625f;
    private final Function<ResourcePath<Model>, Model> modelProvider;
    private final Function<ResourcePath<Texture>, Texture> textureProvider;
    private final TextureGallery textureGallery;
    private final RenderSettings renderSettings;
    private final BlockColorCalculatorFactory.BlockColorCalculator blockColorCalculator;
    private final VectorM3f[] corners = new VectorM3f[8];
    private final VectorM2f[] rawUvs = new VectorM2f[4];
    private final VectorM2f[] uvs = new VectorM2f[4];
    private final Color tintColor = new Color();
    private final Color mapColor = new Color();
    private BlockNeighborhood block;
    private Variant variant;
    private Model modelResource;
    private TileModelView blockModel;
    private Color blockColor;
    private float blockColorOpacity;
    private final MatrixM4f modelElementTransform = new MatrixM4f();
    private final VectorM3f faceRotationVector = new VectorM3f(0.0f, 0.0f, 0.0f);
    private final VectorM3f rotationRelativeBlockDirection = new VectorM3f(0.0f, 0.0f, 0.0f);

    public ResourceModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        int i;
        this.modelProvider = resourcePack.getModels()::get;
        this.textureProvider = resourcePack.getTextures()::get;
        this.textureGallery = textureGallery;
        this.renderSettings = renderSettings;
        this.blockColorCalculator = resourcePack.getColorCalculatorFactory().createCalculator();
        for (i = 0; i < this.corners.length; ++i) {
            this.corners[i] = new VectorM3f(0.0f, 0.0f, 0.0f);
        }
        for (i = 0; i < this.rawUvs.length; ++i) {
            this.rawUvs[i] = new VectorM2f(0.0f, 0.0f);
        }
    }

    @Override
    public void render(BlockNeighborhood block, Variant variant, TileModelView blockModel, Color color) {
        this.block = block;
        this.blockModel = blockModel;
        this.blockColor = color;
        this.blockColorOpacity = 0.0f;
        this.variant = variant;
        this.modelResource = variant.getModel().getResource(this.modelProvider);
        if (this.modelResource == null) {
            return;
        }
        this.tintColor.set(0.0f, 0.0f, 0.0f, -1.0f, true);
        int modelStart = blockModel.getStart();
        Element[] elements = this.modelResource.getElements();
        if (elements != null) {
            for (Element element : elements) {
                this.buildModelElementResource(element, blockModel.initialize());
            }
        }
        if (color.a > 0.0f) {
            color.flatten().straight();
            color.a = this.blockColorOpacity;
        }
        blockModel.initialize(modelStart);
        if (variant.isTransformed()) {
            blockModel.transform(variant.getTransformMatrix());
        }
        if (block.getProperties().isRandomOffset()) {
            float dx = (ResourceModelRenderer.hashToFloat(block.getX(), block.getZ(), 123984L) - 0.5f) * 0.75f;
            float dz = (ResourceModelRenderer.hashToFloat(block.getX(), block.getZ(), 345542L) - 0.5f) * 0.75f;
            blockModel.translate(dx, 0.0f, dz);
        }
    }

    private void buildModelElementResource(Element element, TileModelView blockModel) {
        Vector3f from = element.getFrom();
        Vector3f to = element.getTo();
        float minX = from.getX();
        float minY = from.getY();
        float minZ = from.getZ();
        float maxX = to.getX();
        float maxY = to.getY();
        float maxZ = to.getZ();
        VectorM3f[] c = this.corners;
        c[0].x = minX;
        c[0].y = minY;
        c[0].z = minZ;
        c[1].x = minX;
        c[1].y = minY;
        c[1].z = maxZ;
        c[2].x = maxX;
        c[2].y = minY;
        c[2].z = minZ;
        c[3].x = maxX;
        c[3].y = minY;
        c[3].z = maxZ;
        c[4].x = minX;
        c[4].y = maxY;
        c[4].z = minZ;
        c[5].x = minX;
        c[5].y = maxY;
        c[5].z = maxZ;
        c[6].x = maxX;
        c[6].y = maxY;
        c[6].z = minZ;
        c[7].x = maxX;
        c[7].y = maxY;
        c[7].z = maxZ;
        int modelStart = blockModel.getStart();
        this.createElementFace(element, Direction.DOWN, c[0], c[2], c[3], c[1]);
        this.createElementFace(element, Direction.UP, c[5], c[7], c[6], c[4]);
        this.createElementFace(element, Direction.NORTH, c[2], c[0], c[4], c[6]);
        this.createElementFace(element, Direction.SOUTH, c[1], c[3], c[7], c[5]);
        this.createElementFace(element, Direction.WEST, c[0], c[1], c[5], c[4]);
        this.createElementFace(element, Direction.EAST, c[3], c[2], c[6], c[7]);
        blockModel.initialize(modelStart);
        blockModel.transform(this.modelElementTransform.copy(element.getRotation().getMatrix()).scale(0.0625f, 0.0625f, 0.0625f));
    }

    private void createElementFace(Element element, Direction faceDir, VectorM3f c0, VectorM3f c1, VectorM3f c2, VectorM3f c3) {
        Texture texture;
        Face face = element.getFaces().get((Object)faceDir);
        if (face == null) {
            return;
        }
        Vector3i faceDirVector = faceDir.toVector();
        ExtendedBlock facedBlockNeighbor = this.getRotationRelativeBlock(faceDir);
        LightData blockLightData = this.block.getLightData();
        LightData facedLightData = facedBlockNeighbor.getLightData();
        int sunLight = Math.max(blockLightData.getSkyLight(), facedLightData.getSkyLight());
        int blockLight = Math.max(blockLightData.getBlockLight(), facedLightData.getBlockLight());
        if (this.block.isRemoveIfCave() && (this.renderSettings.isCaveDetectionUsesBlockLight() ? Math.max(blockLight, sunLight) : sunLight) == 0) {
            return;
        }
        this.faceRotationVector.set(faceDirVector.getX(), faceDirVector.getY(), faceDirVector.getZ());
        this.faceRotationVector.rotateAndScale(element.getRotation().getMatrix());
        this.makeRotationRelative(this.faceRotationVector);
        if (this.renderSettings.isRenderTopOnly() && (double)this.faceRotationVector.y < 0.01) {
            return;
        }
        if (face.getCullface() != null) {
            ExtendedBlock b = this.getRotationRelativeBlock(face.getCullface());
            BlockProperties p = b.getProperties();
            if (p.isCulling()) {
                return;
            }
            if (p.getCullingIdentical() && b.getBlockState().equals(this.block.getBlockState())) {
                return;
            }
        }
        this.blockModel.initialize();
        this.blockModel.add(2);
        TileModel tileModel = this.blockModel.getTileModel();
        int face1 = this.blockModel.getStart();
        int face2 = face1 + 1;
        tileModel.setPositions(face1, c0.x, c0.y, c0.z, c1.x, c1.y, c1.z, c2.x, c2.y, c2.z);
        tileModel.setPositions(face2, c0.x, c0.y, c0.z, c2.x, c2.y, c2.z, c3.x, c3.y, c3.z);
        ResourcePath<Texture> texturePath = face.getTexture().getTexturePath(this.modelResource.getTextures()::get);
        int textureId = this.textureGallery.get(texturePath);
        tileModel.setMaterialIndex(face1, textureId);
        tileModel.setMaterialIndex(face2, textureId);
        Vector4f uvRaw = face.getUv();
        float uvx = uvRaw.getX() / 16.0f;
        float uvy = uvRaw.getY() / 16.0f;
        float uvz = uvRaw.getZ() / 16.0f;
        float uvw = uvRaw.getW() / 16.0f;
        this.rawUvs[0].set(uvx, uvw);
        this.rawUvs[1].set(uvz, uvw);
        this.rawUvs[2].set(uvz, uvy);
        this.rawUvs[3].set(uvx, uvy);
        int rotationSteps = Math.floorDiv(face.getRotation(), 90) % 4;
        if (rotationSteps < 0) {
            rotationSteps += 4;
        }
        for (int i = 0; i < 4; ++i) {
            this.uvs[i] = this.rawUvs[(rotationSteps + i) % 4];
        }
        float uvRotation = 0.0f;
        if (this.variant.isUvlock() && this.variant.isTransformed()) {
            float xRotSin = TrigMath.sin((double)((double)this.variant.getX() * (Math.PI / 180)));
            float xRotCos = TrigMath.cos((double)((double)this.variant.getX() * (Math.PI / 180)));
            uvRotation = this.variant.getY() * ((float)faceDirVector.getY() * xRotCos + (float)faceDirVector.getZ() * xRotSin) + this.variant.getX() * (float)(1 - faceDirVector.getY());
        }
        if (uvRotation != 0.0f) {
            uvRotation = (float)((double)uvRotation * (Math.PI / 180));
            float cx = TrigMath.cos((double)uvRotation);
            float cy = TrigMath.sin((double)uvRotation);
            for (VectorM2f uv : this.uvs) {
                uv.translate(-0.5f, -0.5f);
                uv.rotate(cx, cy);
                uv.translate(0.5f, 0.5f);
            }
        }
        tileModel.setUvs(face1, this.uvs[0].x, this.uvs[0].y, this.uvs[1].x, this.uvs[1].y, this.uvs[2].x, this.uvs[2].y);
        tileModel.setUvs(face2, this.uvs[0].x, this.uvs[0].y, this.uvs[2].x, this.uvs[2].y, this.uvs[3].x, this.uvs[3].y);
        if (face.getTintindex() >= 0) {
            if (this.tintColor.a < 0.0f) {
                this.blockColorCalculator.getBlockColor(this.block, this.tintColor);
            }
            tileModel.setColor(face1, this.tintColor.r, this.tintColor.g, this.tintColor.b);
            tileModel.setColor(face2, this.tintColor.r, this.tintColor.g, this.tintColor.b);
        } else {
            tileModel.setColor(face1, 1.0f, 1.0f, 1.0f);
            tileModel.setColor(face2, 1.0f, 1.0f, 1.0f);
        }
        int emissiveBlockLight = Math.max(blockLight, element.getLightEmission());
        tileModel.setBlocklight(face1, emissiveBlockLight);
        tileModel.setBlocklight(face2, emissiveBlockLight);
        tileModel.setSunlight(face1, sunLight);
        tileModel.setSunlight(face2, sunLight);
        float ao0 = 1.0f;
        float ao1 = 1.0f;
        float ao2 = 1.0f;
        float ao3 = 1.0f;
        if (this.modelResource.isAmbientocclusion()) {
            ao0 = this.testAo(c0, faceDir);
            ao1 = this.testAo(c1, faceDir);
            ao2 = this.testAo(c2, faceDir);
            ao3 = this.testAo(c3, faceDir);
        }
        tileModel.setAOs(face1, ao0, ao1, ao2);
        tileModel.setAOs(face2, ao0, ao2, ao3);
        float a = this.faceRotationVector.y;
        if ((double)a > 0.01 && texturePath != null && (texture = texturePath.getResource(this.textureProvider)) != null) {
            this.mapColor.set(texture.getColorPremultiplied());
            if (this.tintColor.a >= 0.0f) {
                this.mapColor.multiply(this.tintColor);
            }
            float combinedLight = Math.max((float)sunLight / 15.0f, (float)blockLight / 15.0f);
            combinedLight = (1.0f - this.renderSettings.getAmbientLight()) * combinedLight + this.renderSettings.getAmbientLight();
            this.mapColor.r *= combinedLight;
            this.mapColor.g *= combinedLight;
            this.mapColor.b *= combinedLight;
            if (this.mapColor.a > this.blockColorOpacity) {
                this.blockColorOpacity = this.mapColor.a;
            }
            this.blockColor.add(this.mapColor);
        }
    }

    private ExtendedBlock getRotationRelativeBlock(Direction direction) {
        return this.getRotationRelativeBlock(direction.toVector());
    }

    private ExtendedBlock getRotationRelativeBlock(Vector3i direction) {
        return this.getRotationRelativeBlock(direction.getX(), direction.getY(), direction.getZ());
    }

    private ExtendedBlock getRotationRelativeBlock(int dx, int dy, int dz) {
        this.rotationRelativeBlockDirection.set(dx, dy, dz);
        this.makeRotationRelative(this.rotationRelativeBlockDirection);
        return this.block.getNeighborBlock(Math.round(this.rotationRelativeBlockDirection.x), Math.round(this.rotationRelativeBlockDirection.y), Math.round(this.rotationRelativeBlockDirection.z));
    }

    private void makeRotationRelative(VectorM3f direction) {
        if (this.variant.isTransformed()) {
            direction.rotateAndScale(this.variant.getTransformMatrix());
        }
    }

    private float testAo(VectorM3f vertex, Direction dir) {
        Vector3i dirVec = dir.toVector();
        int occluding = 0;
        int x = 0;
        if (vertex.x == 16.0f) {
            x = 1;
        } else if (vertex.x == 0.0f) {
            x = -1;
        }
        int y = 0;
        if (vertex.y == 16.0f) {
            y = 1;
        } else if (vertex.y == 0.0f) {
            y = -1;
        }
        int z = 0;
        if (vertex.z == 16.0f) {
            z = 1;
        } else if (vertex.z == 0.0f) {
            z = -1;
        }
        if (x * dirVec.getX() + y * dirVec.getY() > 0 && this.getRotationRelativeBlock(x, y, 0).getProperties().isOccluding()) {
            ++occluding;
        }
        if (x * dirVec.getX() + z * dirVec.getZ() > 0 && this.getRotationRelativeBlock(x, 0, z).getProperties().isOccluding()) {
            ++occluding;
        }
        if (y * dirVec.getY() + z * dirVec.getZ() > 0 && this.getRotationRelativeBlock(0, y, z).getProperties().isOccluding()) {
            ++occluding;
        }
        if (x * dirVec.getX() + y * dirVec.getY() + z * dirVec.getZ() > 0 && this.getRotationRelativeBlock(x, y, z).getProperties().isOccluding()) {
            ++occluding;
        }
        if (occluding > 3) {
            occluding = 3;
        }
        return Math.max(0.0f, Math.min(1.0f - (float)occluding * 0.25f, 1.0f));
    }

    private static float hashToFloat(int x, int z, long seed) {
        long hash = (long)x * 73428767L ^ (long)z * 4382893L ^ seed * 457L;
        return (float)(hash * (hash + 456149L) & 0xFFFFFFL) / 1.6777216E7f;
    }

    public Function<ResourcePath<Model>, Model> getModelProvider() {
        return this.modelProvider;
    }

    public Function<ResourcePath<Texture>, Texture> getTextureProvider() {
        return this.textureProvider;
    }

    public TextureGallery getTextureGallery() {
        return this.textureGallery;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public BlockColorCalculatorFactory.BlockColorCalculator getBlockColorCalculator() {
        return this.blockColorCalculator;
    }
}

