/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map;

import com.flowpowered.math.vector.Vector2i;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.lowres.LowresTileManager;
import de.bluecolored.bluemap.core.util.math.Color;
import java.lang.reflect.Type;
import java.util.Optional;

public class MapSettingsSerializer
implements JsonSerializer<BmMap> {
    public JsonElement serialize(BmMap map, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject root = new JsonObject();
        root.addProperty("name", map.getName());
        root.addProperty("sorting", (Number)map.getMapSettings().getSorting());
        Vector2i hiresTileSize = map.getHiresModelManager().getTileGrid().getGridSize();
        Vector2i gridOrigin = map.getHiresModelManager().getTileGrid().getOffset();
        JsonObject hires = new JsonObject();
        hires.add("tileSize", context.serialize((Object)hiresTileSize));
        hires.add("scale", context.serialize((Object)Vector2i.ONE));
        hires.add("translate", context.serialize((Object)gridOrigin));
        root.add("hires", (JsonElement)hires);
        LowresTileManager lowresTileManager = map.getLowresTileManager();
        JsonObject lowres = new JsonObject();
        lowres.add("tileSize", context.serialize((Object)lowresTileManager.getTileGrid().getGridSize()));
        lowres.add("lodFactor", context.serialize((Object)lowresTileManager.getLodFactor()));
        lowres.add("lodCount", context.serialize((Object)lowresTileManager.getLodCount()));
        root.add("lowres", (JsonElement)lowres);
        Vector2i startPos = Optional.ofNullable(map.getMapSettings().getStartPos()).orElse(map.getWorld().getSpawnPoint().toVector2(true));
        root.add("startPos", context.serialize((Object)startPos));
        Color skyColor = new Color().parse(map.getMapSettings().getSkyColor());
        root.add("skyColor", context.serialize((Object)skyColor));
        Color voidColor = new Color().parse(map.getMapSettings().getVoidColor());
        root.add("voidColor", context.serialize((Object)voidColor));
        root.addProperty("ambientLight", (Number)Float.valueOf(map.getMapSettings().getAmbientLight()));
        root.addProperty("skyLight", (Number)Float.valueOf(map.getMapSettings().getSkyLight()));
        root.addProperty("perspectiveView", Boolean.valueOf(map.getMapSettings().isEnablePerspectiveView()));
        root.addProperty("flatView", Boolean.valueOf(map.getMapSettings().isEnableFlatView()));
        root.addProperty("freeFlightView", Boolean.valueOf(map.getMapSettings().isEnableFreeFlightView()));
        return root;
    }
}

