/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpConnection;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.Server;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class HttpServer
extends Server {
    private HttpRequestHandler requestHandler;
    private ExecutorService executor;

    public HttpServer(HttpRequestHandler requestHandler, ExecutorService executor) throws IOException {
        this.requestHandler = requestHandler;
        this.executor = executor;
    }

    public HttpServer(HttpRequestHandler requestHandler) throws IOException {
        this(requestHandler, Executors.newVirtualThreadPerTaskExecutor());
    }

    @Override
    public void handleConnection(SocketChannel connection) throws IOException {
        connection.socket().setSoTimeout(600000);
        this.executor.execute(new HttpConnection(connection.socket(), this.requestHandler));
    }

    public HttpRequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    public void setRequestHandler(HttpRequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }
}

