/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class HttpResponseOutputStream
implements Closeable {
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.UTF_8);
    private final OutputStream outputStream;
    private final byte[] byteBuffer = new byte[1024];

    public void write(HttpResponse response) throws IOException {
        HttpStatusCode statusCode = response.getStatusCode();
        InputStream body = response.getBody();
        this.writeLine(response.getVersion() + " " + statusCode.getCode() + " " + statusCode.getMessage());
        if (body != null) {
            response.addHeader("Transfer-Encoding", "chunked");
        } else {
            response.addHeader("Content-Length", "0");
        }
        for (HttpHeader header : response.getHeaders().values()) {
            this.writeLine(header.getKey() + ": " + header.getValue());
        }
        this.writeLine();
        if (body != null) {
            int read;
            while ((read = body.read(this.byteBuffer)) != -1) {
                if (read == 0) continue;
                this.writeLine(Integer.toHexString(read));
                this.outputStream.write(this.byteBuffer, 0, read);
                this.writeLine();
            }
            this.writeLine(Integer.toHexString(0));
            this.writeLine();
        }
        this.outputStream.flush();
    }

    private void writeLine() throws IOException {
        this.outputStream.write(CRLF);
    }

    private void writeLine(String line) throws IOException {
        this.outputStream.write(line.getBytes(StandardCharsets.UTF_8));
        this.outputStream.write(CRLF);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public HttpResponseOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

