/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpHeaderCarrier;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class HttpResponse
implements Closeable,
HttpHeaderCarrier {
    @NonNull
    private String version = "HTTP/1.1";
    @NonNull
    private HttpStatusCode statusCode;
    @NonNull
    private Map<String, HttpHeader> headers = new LinkedHashMap<String, HttpHeader>();
    @Nullable
    private InputStream body;

    public void setBody(@Nullable InputStream body) {
        this.body = body;
    }

    public void setBody(byte[] data) {
        if (data == null) {
            this.body = null;
            return;
        }
        this.setBody(new ByteArrayInputStream(data));
    }

    public void setBody(String data) {
        if (data == null) {
            this.body = null;
            return;
        }
        this.setBody(data.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
        if (this.body != null) {
            this.body.close();
        }
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @NonNull
    public HttpStatusCode getStatusCode() {
        return this.statusCode;
    }

    @Override
    @NonNull
    public Map<String, HttpHeader> getHeaders() {
        return this.headers;
    }

    @Nullable
    public InputStream getBody() {
        return this.body;
    }

    public void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    public void setStatusCode(@NonNull HttpStatusCode statusCode) {
        if (statusCode == null) {
            throw new NullPointerException("statusCode is marked non-null but is null");
        }
        this.statusCode = statusCode;
    }

    public void setHeaders(@NonNull Map<String, HttpHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.headers = headers;
    }

    public HttpResponse(@NonNull HttpStatusCode statusCode) {
        if (statusCode == null) {
            throw new NullPointerException("statusCode is marked non-null but is null");
        }
        this.statusCode = statusCode;
    }
}

