/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class HttpRequestInputStream
implements Closeable {
    private static final Pattern REQUEST_PATTERN = Pattern.compile("^(\\w+) (\\S+) (.+)$");
    private final InetAddress source;
    private final DataInputStream in;
    private final Reader reader;
    private byte[] byteBuffer = new byte[1024];
    private final char[] charBuffer = new char[1];

    public HttpRequestInputStream(InputStream in, InetAddress source) {
        this.source = source;
        this.in = new DataInputStream(in);
        this.reader = new InputStreamReader((InputStream)this.in, StandardCharsets.UTF_8);
    }

    @Nullable
    public HttpRequest read() throws IOException {
        String line;
        String requestLine = this.readLine();
        Matcher m4 = REQUEST_PATTERN.matcher(requestLine);
        if (!m4.find()) {
            throw new IOException("Invalid HTTP Request: Request-Pattern not matching '%s'".formatted(requestLine));
        }
        URI address = URI.create(m4.group(2));
        HttpRequest request = new HttpRequest(this.source, m4.group(1), address.getPath());
        request.setVersion(m4.group(3));
        request.setRawQueryString(address.getRawQuery());
        while (!(line = this.readLine()).isBlank()) {
            String[] kv = line.split(":", 2);
            if (kv.length < 2) continue;
            request.addHeader(kv[0], kv[1].trim());
        }
        if (request.hasHeaderValue("transfer-encoding", "chunked")) {
            request.setBody(this.readChunkedBody());
        } else {
            HttpHeader contentLengthHeader = request.getHeader("content-length");
            int contentLength = 0;
            if (contentLengthHeader != null) {
                try {
                    contentLength = Integer.parseInt(contentLengthHeader.getValue().trim());
                }
                catch (NumberFormatException ex) {
                    throw new IOException("Invalid HTTP Request: content-length is not a number", ex);
                }
            }
            if (contentLength > 0) {
                request.setBody(this.readBody(contentLength));
            }
        }
        return request;
    }

    private String readLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if (this.reader.read(this.charBuffer, 0, 1) == -1) {
                throw new EOFException();
            }
            stringBuilder.append(this.charBuffer, 0, 1);
        } while (this.charBuffer[0] != '\n');
        return stringBuilder.toString();
    }

    private byte[] readChunkedBody() throws IOException {
        int size;
        ByteArrayOutputStream body = new ByteArrayOutputStream(1024);
        do {
            String prefix;
            if ((size = Integer.valueOf((prefix = this.readLine()).formatted(new Object[0]), 16).intValue()) > this.byteBuffer.length) {
                this.byteBuffer = new byte[size];
            }
            size = this.in.readNBytes(this.byteBuffer, 0, size);
            body.write(this.byteBuffer, 0, size);
            this.readLine();
        } while (size != 0);
        return body.toByteArray();
    }

    private byte[] readBody(int contentLength) throws IOException {
        return this.in.readNBytes(contentLength);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

