/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpHeaderCarrier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequest
implements HttpHeaderCarrier {
    @NonNull
    private InetAddress source;
    @NonNull
    private String method;
    @NonNull
    private String path;
    @NonNull
    private Map<String, String> queryParams = new LinkedHashMap<String, String>();
    @NonNull
    private String version = "HTTP/1.1";
    @NonNull
    private Map<String, HttpHeader> headers = new LinkedHashMap<String, HttpHeader>();
    private byte @NonNull [] body = new byte[0];

    public String getQueryParam(String key) {
        return this.queryParams.get(key);
    }

    public String getRawQueryString() {
        return this.queryParams.entrySet().stream().map(e -> ((String)e.getValue()).isEmpty() ? (String)e.getKey() : URLEncoder.encode((String)e.getKey(), StandardCharsets.UTF_8) + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
    }

    public void setRawQueryString(@Nullable String rawQueryString) {
        this.queryParams.clear();
        if (rawQueryString == null) {
            return;
        }
        for (String param : rawQueryString.split("&")) {
            if (param.isEmpty()) continue;
            String[] kv = param.split("=", 2);
            String key = URLDecoder.decode(kv[0], StandardCharsets.UTF_8);
            String value = kv.length > 1 ? URLDecoder.decode(kv[1], StandardCharsets.UTF_8) : "";
            this.queryParams.put(key, value);
        }
    }

    public InputStream getBodyStream() {
        return new ByteArrayInputStream(this.body);
    }

    @NonNull
    public InetAddress getSource() {
        return this.source;
    }

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public String getPath() {
        return this.path;
    }

    @NonNull
    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    @NonNull
    public String getVersion() {
        return this.version;
    }

    @Override
    @NonNull
    public Map<String, HttpHeader> getHeaders() {
        return this.headers;
    }

    public byte @NonNull [] getBody() {
        return this.body;
    }

    public void setSource(@NonNull InetAddress source) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.source = source;
    }

    public void setMethod(@NonNull String method) {
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        this.method = method;
    }

    public void setPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }

    public void setQueryParams(@NonNull Map<String, String> queryParams) {
        if (queryParams == null) {
            throw new NullPointerException("queryParams is marked non-null but is null");
        }
        this.queryParams = queryParams;
    }

    public void setVersion(@NonNull String version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        this.version = version;
    }

    public void setHeaders(@NonNull Map<String, HttpHeader> headers) {
        if (headers == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.headers = headers;
    }

    public void setBody(byte @NonNull [] body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        this.body = body;
    }

    public HttpRequest(@NonNull InetAddress source, @NonNull String method, @NonNull String path) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.source = source;
        this.method = method;
        this.path = path;
    }
}

