/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class HttpHeader {
    private final String key;
    private String value;
    private List<String> values;
    private Set<String> valuesLC;

    public HttpHeader(String key, String ... values) {
        this.key = key;
        this.value = String.join((CharSequence)",", values);
    }

    public synchronized void add(String ... values) {
        if (this.value.isEmpty()) {
            this.set(values);
            return;
        }
        this.value = this.value + "," + String.join((CharSequence)",", values);
        this.values = null;
        this.valuesLC = null;
    }

    public synchronized void set(String ... values) {
        this.value = String.join((CharSequence)",", values);
        this.values = null;
        this.valuesLC = null;
    }

    public synchronized List<String> getValues() {
        if (this.values == null) {
            ArrayList<String> vs = new ArrayList<String>();
            for (String v : this.value.split(",")) {
                vs.add(v.trim());
            }
            this.values = Collections.unmodifiableList(vs);
        }
        return this.values;
    }

    public synchronized boolean contains(String value) {
        if (this.valuesLC == null) {
            this.valuesLC = new HashSet<String>();
            for (String v : this.getValues()) {
                this.valuesLC.add(v.toLowerCase(Locale.ROOT));
            }
        }
        return this.valuesLC.contains(value);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeader that = (HttpHeader)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return this.key + ": " + this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

