/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web.http;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpRequestInputStream;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpResponseOutputStream;
import de.bluecolored.bluemap.core.logger.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class HttpConnection
implements Runnable {
    private final Socket socket;
    private final HttpRequestInputStream requestIn;
    private final HttpResponseOutputStream responseOut;
    private final HttpRequestHandler requestHandler;

    public HttpConnection(Socket socket, HttpRequestHandler requestHandler) throws IOException {
        this.socket = socket;
        this.requestHandler = requestHandler;
        this.requestIn = new HttpRequestInputStream(new BufferedInputStream(socket.getInputStream()), socket.getInetAddress());
        this.responseOut = new HttpResponseOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.socket.isConnected()) {
                if (this.socket.isClosed()) return;
                if (this.socket.isInputShutdown()) return;
                if (this.socket.isOutputShutdown()) return;
                HttpRequest request = this.requestIn.read();
                if (request == null) continue;
                HttpResponse response = this.requestHandler.handle(request);
                try {
                    this.responseOut.write(response);
                }
                finally {
                    if (response == null) continue;
                    response.close();
                }
            }
            return;
        }
        catch (EOFException | SocketTimeoutException e) {
            return;
        }
        catch (IOException e) {
            if (e.getMessage() != null) {
                if (e.getMessage().equals("Broken pipe")) return;
            }
            Logger.global.logDebug("Exception in HttpConnection: " + String.valueOf(e));
            return;
        }
        catch (Exception e) {
            Logger.global.logDebug("Exception in HttpConnection: " + String.valueOf(e));
            return;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                Logger.global.logDebug("Exception closing HttpConnection: " + String.valueOf(e));
            }
        }
    }
}

