/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpHeader;
import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import de.bluecolored.bluemap.core.logger.Logger;
import lombok.NonNull;

public class LoggingRequestHandler
implements HttpRequestHandler {
    @NonNull
    private HttpRequestHandler delegate;
    @NonNull
    private String format;
    @NonNull
    private Logger logger;

    public LoggingRequestHandler(HttpRequestHandler delegate) {
        this(delegate, Logger.global);
    }

    public LoggingRequestHandler(HttpRequestHandler delegate, Logger logger) {
        this(delegate, "", logger);
    }

    public LoggingRequestHandler(HttpRequestHandler delegate, String format) {
        this(delegate, format, Logger.global);
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        String source;
        String xffSource = source = request.getSource().toString();
        HttpHeader xffHeader = request.getHeader("X-Forwarded-For");
        if (xffHeader != null && !xffHeader.getValues().isEmpty()) {
            xffSource = xffHeader.getValues().get(0);
        }
        String method = request.getMethod();
        String path = request.getPath();
        String queryString = request.getRawQueryString();
        String address = queryString == null ? path : path + "?" + queryString;
        String version = request.getVersion();
        HttpResponse response = this.delegate.handle(request);
        HttpStatusCode status = response.getStatusCode();
        int statusCode = status.getCode();
        String statusMessage = status.getMessage();
        String log = String.format(this.format, source, xffSource, method, address, version, statusCode, statusMessage);
        if (statusCode < 500) {
            this.logger.logInfo(log);
        } else {
            this.logger.logWarning(log);
        }
        return response;
    }

    @NonNull
    public HttpRequestHandler getDelegate() {
        return this.delegate;
    }

    @NonNull
    public String getFormat() {
        return this.format;
    }

    @NonNull
    public Logger getLogger() {
        return this.logger;
    }

    public void setDelegate(@NonNull HttpRequestHandler delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    public void setFormat(@NonNull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setLogger(@NonNull Logger logger) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.logger = logger;
    }

    public LoggingRequestHandler(@NonNull HttpRequestHandler delegate, @NonNull String format, @NonNull Logger logger) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        this.delegate = delegate;
        this.format = format;
        this.logger = logger;
    }
}

