/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.web;

import de.bluecolored.bluemap.common.web.http.HttpRequest;
import de.bluecolored.bluemap.common.web.http.HttpRequestHandler;
import de.bluecolored.bluemap.common.web.http.HttpResponse;
import de.bluecolored.bluemap.common.web.http.HttpStatusCode;
import java.util.function.Supplier;
import lombok.NonNull;

public class JsonDataRequestHandler
implements HttpRequestHandler {
    @NonNull
    private Supplier<String> dataSupplier;

    public JsonDataRequestHandler(Supplier<String> dataSupplier) {
        this.dataSupplier = dataSupplier;
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        HttpResponse response = new HttpResponse(HttpStatusCode.OK);
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Content-Type", "application/json");
        response.setBody(this.dataSupplier.get());
        return response;
    }

    @NonNull
    public Supplier<String> getDataSupplier() {
        return this.dataSupplier;
    }

    public void setDataSupplier(@NonNull Supplier<String> dataSupplier) {
        if (dataSupplier == null) {
            throw new NullPointerException("dataSupplier is marked non-null but is null");
        }
        this.dataSupplier = dataSupplier;
    }
}

