/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.shadow.configurate.gson.GsonConfigurationLoader;
import de.bluecolored.shadow.configurate.hocon.HoconConfigurationLoader;
import de.bluecolored.shadow.configurate.loader.AbstractConfigurationLoader;
import java.util.function.Supplier;

public interface ConfigLoader
extends Keyed {
    public static final ConfigLoader HOCON = new Impl(Key.bluemap("hocon"), ".conf", HoconConfigurationLoader::builder);
    public static final ConfigLoader JSON = new Impl(Key.bluemap("json"), ".json", GsonConfigurationLoader::builder);
    public static final ConfigLoader DEFAULT = HOCON;
    public static final Registry<ConfigLoader> REGISTRY = new Registry((Keyed[])new ConfigLoader[]{HOCON, JSON});

    public String getFileSuffix();

    public AbstractConfigurationLoader.Builder<?, ?> createLoaderBuilder();

    public static class Impl
    implements ConfigLoader {
        private final Key key;
        private final String fileSuffix;
        private final Supplier<AbstractConfigurationLoader.Builder<?, ?>> builderSupplier;

        @Override
        public AbstractConfigurationLoader.Builder<?, ?> createLoaderBuilder() {
            return this.builderSupplier.get();
        }

        public Impl(Key key, String fileSuffix, Supplier<AbstractConfigurationLoader.Builder<?, ?>> builderSupplier) {
            this.key = key;
            this.fileSuffix = fileSuffix;
            this.builderSupplier = builderSupplier;
        }

        @Override
        public Key getKey() {
            return this.key;
        }

        @Override
        public String getFileSuffix() {
            return this.fileSuffix;
        }

        public Supplier<AbstractConfigurationLoader.Builder<?, ?>> getBuilderSupplier() {
            return this.builderSupplier;
        }
    }
}

