/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.MapHasCorrectWorldCheck;
import de.bluecolored.bluemap.common.commands.checks.MapIsNotFrozenCheck;
import de.bluecolored.bluemap.common.commands.checks.MapIsUpdatedCheck;
import de.bluecolored.bluemap.common.commands.checks.RenderThreadsRunningCheck;
import de.bluecolored.bluemap.common.commands.checks.TileHasLightDataCheck;
import de.bluecolored.bluemap.common.commands.checks.TileInsideBoundsCheck;
import de.bluecolored.bluemap.common.commands.checks.TileIsUpdatedCheck;
import de.bluecolored.bluemap.common.commands.checks.TileNoChunkErrorCheck;
import de.bluecolored.bluemap.common.commands.checks.TileNoRenderErrorCheck;
import de.bluecolored.bluemap.common.commands.checks.WorldHasMapsCheck;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.map.BmMap;
import java.util.Arrays;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class TroubleshootCommand {
    private final Plugin plugin;

    @Command(value={"troubleshoot"})
    @Permission(value="bluemap.troubleshoot")
    public Component troubleshoot(ServerWorld world, Vector3d position) {
        return this.runChecks(() -> {
            BmMap[] maps;
            if (world != null) {
                WorldHasMapsCheck worldHasMapsCheck = new WorldHasMapsCheck(this.plugin, world);
                worldHasMapsCheck.test();
                maps = worldHasMapsCheck.getMaps();
            } else {
                maps = (BmMap[])this.plugin.getBlueMap().getMaps().values().toArray(BmMap[]::new);
            }
            Vector2i position2i = position != null ? position.toVector2(true).toInt() : null;
            this.troubleshoot(maps, position2i);
        });
    }

    @Command(value={"troubleshoot <map>"})
    @Permission(value="bluemap.troubleshoot")
    public Component troubleshoot(ServerWorld world, Vector3d position, @Argument(value="map") BmMap map) {
        return this.runChecks(() -> {
            if (world != null) {
                new MapHasCorrectWorldCheck(this.plugin, map, world).test();
            }
            Vector2i position2i = position != null ? position.toVector2(true).toInt() : null;
            this.troubleshoot(new BmMap[]{map}, position2i);
        });
    }

    @Command(value={"troubleshoot <map> <x> <z>"})
    @Permission(value="bluemap.troubleshoot")
    public Component troubleshoot(@Argument(value="map") BmMap map, @Argument(value="x") int x, @Argument(value="z") int z) {
        return this.runChecks(() -> {
            Vector2i position2i = new Vector2i(x, z);
            this.troubleshoot(new BmMap[]{map}, position2i);
        });
    }

    private void troubleshoot(BmMap[] maps, @Nullable Vector2i position) throws Check.CheckFailedException {
        new RenderThreadsRunningCheck(this.plugin).test();
        if (position != null) {
            for (BmMap map : maps) {
                this.troubleshootTileAt(map, position);
            }
            for (BmMap map : maps) {
                new TileIsUpdatedCheck(this.plugin, map, position).test();
            }
        }
        for (BmMap map : maps) {
            new MapIsUpdatedCheck(this.plugin, map).test();
        }
        for (BmMap map : maps) {
            new MapIsNotFrozenCheck(this.plugin, map).test();
        }
        if (position != null) {
            for (BmMap map : maps) {
                new TileInsideBoundsCheck(this.plugin, map, position).test();
            }
        }
    }

    private void troubleshootTileAt(BmMap map, Vector2i position) throws Check.CheckFailedException {
        Check[] regionChecks = new Check[]{new TileNoRenderErrorCheck(map, position), new TileNoChunkErrorCheck(map, position), new TileHasLightDataCheck(map, position)};
        boolean anyFails = Arrays.stream(regionChecks).anyMatch(Check::failed);
        if (anyFails) {
            new TileIsUpdatedCheck(this.plugin, map, position).test();
            new MapIsNotFrozenCheck(this.plugin, map).test();
            for (Check check : regionChecks) {
                check.test();
            }
        }
    }

    private Component runChecks(CheckRun run) {
        try {
            run.test();
            return this.result(Component.text((String)"\u2714 no issues found").color(TextFormat.POSITIVE_COLOR));
        }
        catch (Check.CheckFailedException ex) {
            return this.result(ex.getCheck().getFailureDescription().color(TextFormat.WARNING_COLOR));
        }
    }

    private Component result(Component result) {
        return TextFormat.paragraph("Troubleshooting", result);
    }

    public TroubleshootCommand(Plugin plugin) {
        this.plugin = plugin;
    }

    private static interface CheckRun {
        public void test() throws Check.CheckFailedException;
    }
}

