/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.commands;

import de.bluecolored.bluecommands.annotations.Argument;
import de.bluecolored.bluecommands.annotations.Command;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.commands.Permission;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;

public class TasksCommand {
    private final Plugin plugin;

    @Command(value={"tasks"})
    @Permission(value="bluemap.tasks")
    public Component taskList() {
        Map<RenderTask, Long> completedTasks = this.plugin.getRenderManager().getCompletedTasks();
        List<RenderTask> scheduledTasks = this.plugin.getRenderManager().getScheduledRenderTasks();
        RenderTask currentTask = scheduledTasks.isEmpty() ? null : scheduledTasks.removeFirst();
        LinkedList<Component> tasks = new LinkedList<Component>();
        if (completedTasks.size() > 3) {
            tasks.add(Component.text((String)"... more done tasks ...").color(TextFormat.BASE_COLOR));
        }
        completedTasks.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(3L).sorted(Map.Entry.comparingByValue()).map(entry -> TextFormat.format("% % %", TextFormat.ICON_UPDATED, Component.text((String)"(done)").decorate(TextDecoration.ITALIC), ((RenderTask)entry.getKey()).getDescription()).color(TextFormat.BASE_COLOR)).forEach(tasks::add);
        if (currentTask != null) {
            tasks.add(TextFormat.format("% % % ...", TextFormat.ICON_IN_PROGRESS, this.formatTaskRef(currentTask), currentTask.getDescription()).color(TextFormat.HIGHLIGHT_COLOR));
        }
        scheduledTasks.stream().limit(6L).map(task -> TextFormat.format("% % %", TextFormat.ICON_PENDING, this.formatTaskRef((RenderTask)task), task.getDescription()).color(TextFormat.INFO_COLOR)).forEach(tasks::add);
        if (scheduledTasks.size() > 6) {
            tasks.add(TextFormat.format("... % more scheduled tasks ...", scheduledTasks.size() - 6).color(TextFormat.BASE_COLOR));
        }
        if (scheduledTasks.isEmpty() && currentTask == null) {
            tasks.add(TextFormat.format("% no pending tasks, all done", TextFormat.ICON_UPDATED).color(TextFormat.POSITIVE_COLOR));
        }
        return TextFormat.paragraph("Tasks", TextFormat.lines(tasks));
    }

    @Command(value={"tasks cancel <task-ref>"})
    @Permission(value="bluemap.tasks.cancel")
    public Component cancelTask(@Argument(value="task-ref") RenderTask renderTask) {
        boolean removed = this.plugin.getRenderManager().removeRenderTask(renderTask);
        if (!removed) {
            return Component.text((String)"Task is not pending or already completed").color(TextFormat.NEGATIVE_COLOR);
        }
        return Component.text((String)"Task cancelled").color(TextFormat.POSITIVE_COLOR);
    }

    private Component formatTaskRef(RenderTask renderTask) {
        return TextFormat.format("[%]", Commands.getRefForTask(renderTask)).color(TextFormat.BASE_COLOR);
    }

    public TasksCommand(Plugin plugin) {
        this.plugin = plugin;
    }
}

