/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands.checks;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.commands.checks.Check;
import de.bluecolored.bluemap.common.commands.checks.CheckResult;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;

public class TileNoRenderErrorCheck
implements Check {
    private final BmMap map;
    private final Vector2i position;
    private final Vector2i tile;
    private final TileInfoRegion.TileInfo tileInfo;

    public TileNoRenderErrorCheck(BmMap map, Vector2i position) {
        this.map = map;
        this.position = position;
        this.tile = map.getHiresModelManager().getTileGrid().getCell(position);
        this.tileInfo = map.getMapTileState().get(this.tile.getX(), this.tile.getY());
    }

    @Override
    public CheckResult getResult() {
        return this.tileInfo.getState() != TileState.RENDER_ERROR ? CheckResult.OK : CheckResult.BAD;
    }

    @Override
    public Component getFailureDescription() {
        LocalDateTime failureTime = LocalDateTime.ofInstant(Instant.ofEpochSecond(this.tileInfo.getRenderTime()), ZoneId.systemDefault());
        return TextFormat.lines(new Component[]{TextFormat.format("\u26a0 there was an error while rendering\naround (x:%, z:%) for map %\n".strip(), Component.text((int)this.position.getX()).color(TextFormat.HIGHLIGHT_COLOR), Component.text((int)this.position.getY()).color(TextFormat.HIGHLIGHT_COLOR), TextFormat.formatMap(this.map).color(TextFormat.HIGHLIGHT_COLOR)), Component.empty(), TextFormat.format("check your server-logs for errors\naround %\n\nif the problem persists, you can visit bluemaps % for help\n".strip(), Component.text((String)TextFormat.DATE_TIME_FORMAT.format(failureTime)).color(TextFormat.HIGHLIGHT_COLOR), ((TextComponent)((TextComponent)Component.text((String)"discord").hoverEvent((HoverEventSource)Component.text((String)"https://discord.gg/zmkyJa3"))).clickEvent(ClickEvent.openUrl((String)"https://discord.gg/zmkyJa3"))).color(TextFormat.HIGHLIGHT_COLOR)).color(TextFormat.BASE_COLOR)});
    }

    public BmMap getMap() {
        return this.map;
    }

    public Vector2i getPosition() {
        return this.position;
    }

    public Vector2i getTile() {
        return this.tile;
    }

    public TileInfoRegion.TileInfo getTileInfo() {
        return this.tileInfo;
    }

    public TileNoRenderErrorCheck(BmMap map, Vector2i position, Vector2i tile, TileInfoRegion.TileInfo tileInfo) {
        this.map = map;
        this.position = position;
        this.tile = tile;
        this.tileInfo = tileInfo;
    }
}

