/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.commands;

import de.bluecolored.bluecommands.ParseMatch;
import de.bluecolored.bluecommands.ParseResult;
import de.bluecolored.bluemap.common.commands.Commands;
import de.bluecolored.bluemap.common.commands.TextFormat;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;

public class CommandExecutor {
    private final Plugin plugin;

    public ExecutionResult execute(ParseResult<CommandSource, Object> parseResult) {
        if (parseResult.getMatches().isEmpty()) {
            if (!Commands.checkPluginLoaded(this.plugin, parseResult.getContext())) {
                return new ExecutionResult(0, false);
            }
            return new ExecutionResult(0, true);
        }
        ParseMatch match = parseResult.getMatches().stream().max(Comparator.comparing(ParseMatch::getPriority)).orElseThrow(IllegalStateException::new);
        if (!Commands.checkExecutablePreconditions(this.plugin, (CommandSource)match.getContext(), match.getExecutable())) {
            return new ExecutionResult(0, false);
        }
        return (ExecutionResult)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(match::execute, BlueMap.THREAD_POOL).thenApply(result -> {
            Object selector0$temp = result;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, ComponentLike.class, Boolean.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    Number n = (Number)selector0$temp;
                    yield n.intValue();
                }
                case 1 -> {
                    ComponentLike c = (ComponentLike)selector0$temp;
                    ((CommandSource)match.getContext()).sendMessage(c.asComponent());
                    yield 1;
                }
                case 2 -> {
                    Boolean b = (Boolean)selector0$temp;
                    yield b != false ? 1 : 0;
                }
                default -> 1;
            };
        })).exceptionally(e -> {
            Logger.global.logError("Command execution for '%s' failed".formatted(parseResult.getInput()), (Throwable)e);
            ((CommandSource)parseResult.getContext()).sendMessage(Component.text((String)"There was an error executing this command! See logs or console for details.").color(TextFormat.NEGATIVE_COLOR));
            return 0;
        })).completeOnTimeout(1, 100L, TimeUnit.MILLISECONDS).thenApply(code -> new ExecutionResult((int)code, false))).join();
    }

    public CommandExecutor(Plugin plugin) {
        this.plugin = plugin;
    }

    public record ExecutionResult(int resultCode, boolean parseFailure) {
    }
}

