/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.bluecolored.bluemap.common.config.WebappConfig;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;

public class WebFilesManager {
    private static final Gson GSON = ResourcesGson.addAdapter(new GsonBuilder()).setFieldNamingPolicy(FieldNamingPolicy.IDENTITY).create();
    private final Path webRoot;
    private Settings settings;

    public WebFilesManager(Path webRoot) {
        this.webRoot = webRoot;
        this.settings = new Settings();
    }

    public Path getSettingsFile() {
        return this.webRoot.resolve("settings.json");
    }

    public void loadSettings() throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(this.getSettingsFile());){
            this.settings = (Settings)GSON.fromJson((Reader)reader, Settings.class);
        }
    }

    public void saveSettings() throws IOException {
        FileHelper.createDirectories(this.getSettingsFile().getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(this.getSettingsFile(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)this.settings, (Appendable)writer);
        }
    }

    public void resetSettings() {
        this.settings = new Settings();
    }

    public void addMap(String mapId) {
        this.settings.maps.add(mapId);
    }

    public void removeMap(String mapId) {
        this.settings.maps.remove(mapId);
    }

    public Set<String> getScripts() {
        return this.settings.scripts;
    }

    public Set<String> getStyles() {
        return this.settings.styles;
    }

    public void setFrom(WebappConfig webappConfig) {
        this.settings.setFrom(webappConfig);
    }

    public void addFrom(WebappConfig webappConfig) {
        this.settings.addFrom(webappConfig);
    }

    public boolean filesNeedUpdate() {
        return !Files.exists(this.webRoot.resolve("index.html"), new LinkOption[0]);
    }

    public void updateFiles() throws IOException {
        URL zippedWebapp = this.getClass().getResource("/de/bluecolored/bluemap/webapp.zip");
        if (zippedWebapp == null) {
            throw new IOException("Failed to open bundled webapp.");
        }
        Files.createDirectories(this.webRoot, new FileAttribute[0]);
        FileHelper.extractZipFile(zippedWebapp, this.webRoot, StandardCopyOption.REPLACE_EXISTING);
    }

    private static class Settings {
        private String version = BlueMap.VERSION;
        private boolean useCookies = true;
        private boolean defaultToFlatView = false;
        private String startLocation = null;
        private float resolutionDefault = 1.0f;
        private int minZoomDistance = 5;
        private int maxZoomDistance = 100000;
        private int hiresSliderMax = 500;
        private int hiresSliderDefault = 200;
        private int hiresSliderMin = 50;
        private int lowresSliderMax = 10000;
        private int lowresSliderDefault = 2000;
        private int lowresSliderMin = 500;
        private String mapDataRoot = "maps";
        private String liveDataRoot = "maps";
        private Set<String> maps = new HashSet<String>();
        private Set<String> scripts = new HashSet<String>();
        private Set<String> styles = new HashSet<String>();

        private Settings() {
        }

        public void setFrom(WebappConfig config) {
            this.useCookies = config.isUseCookies();
            this.defaultToFlatView = config.isDefaultToFlatView();
            this.startLocation = config.getStartLocation().orElse(null);
            this.resolutionDefault = config.getResolutionDefault();
            this.minZoomDistance = config.getMinZoomDistance();
            this.maxZoomDistance = config.getMaxZoomDistance();
            this.hiresSliderMax = config.getHiresSliderMax();
            this.hiresSliderDefault = config.getHiresSliderDefault();
            this.hiresSliderMin = config.getHiresSliderMin();
            this.lowresSliderMax = config.getLowresSliderMax();
            this.lowresSliderDefault = config.getLowresSliderDefault();
            this.lowresSliderMin = config.getLowresSliderMin();
            this.mapDataRoot = config.getMapDataRoot();
            this.liveDataRoot = config.getLiveDataRoot();
            this.styles.clear();
            this.scripts.clear();
            this.addFrom(config);
        }

        public void addFrom(WebappConfig config) {
            Set<String> scripts = config.getScripts();
            for (String script : scripts) {
                this.scripts.add(script);
                Logger.global.logDebug("Registering script from Webapp Config: " + script);
            }
            Set<String> styles = config.getStyles();
            for (String style : styles) {
                this.styles.add(style);
                Logger.global.logDebug("Registering style from Webapp Config: " + style);
            }
        }
    }
}

