/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.bukkit;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.bukkit.BukkitPlugin;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.ConsoleCommandSender;

public class BukkitCommandSource
implements CommandSource {
    private final CommandSourceStack delegate;

    public BukkitCommandSource(CommandSourceStack delegate) {
        this.delegate = delegate;
    }

    @Override
    public void sendMessage(Component text) {
        this.delegate.getSender().sendMessage(text.compact());
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.delegate.getSender().hasPermission(permission);
    }

    @Override
    public Optional<Vector3d> getPosition() {
        if (this.delegate.getSender() instanceof ConsoleCommandSender) {
            return Optional.empty();
        }
        Location location = this.delegate.getLocation();
        return Optional.of(new Vector3d(location.getX(), location.getY(), location.getZ()));
    }

    @Override
    public Optional<ServerWorld> getWorld() {
        if (this.delegate.getSender() instanceof ConsoleCommandSender) {
            return Optional.empty();
        }
        World world = this.delegate.getLocation().getWorld();
        if (world == null) {
            return Optional.empty();
        }
        return Optional.of(BukkitPlugin.getInstance().getServerWorld(world));
    }
}

