/*
 * Decompiled with CFR 0.152.
 */
package org.voidish.consoleFilter;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class UpdateChecker {
    private static final String JSON_URL = "https://voidish.xyz/consolefilter.json";
    private final FileConfiguration config;
    private static final Logger log = Logger.getLogger("ConsoleFilter");

    public UpdateChecker(JavaPlugin plugin) {
        this.config = plugin.getConfig();
    }

    public void checkForUpdates() {
        String currentVersion = this.config.getString("version", "1.0.0");
        log.info("Checking for Updates...");
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(JSON_URL)).build();
            CompletableFuture<HttpResponse<String>> response = client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
            ((CompletableFuture)response.thenAccept(res -> {
                String content = (String)res.body();
                Gson gson = new Gson();
                JsonObject jsonResponse = (JsonObject)gson.fromJson(content, JsonObject.class);
                JsonObject latestUpdate = jsonResponse.getAsJsonObject("latest");
                String latestVersion = latestUpdate.get("version").getAsString();
                String downloadUrl = latestUpdate.get("download_url").getAsString();
                String changelog = latestUpdate.get("changelog").getAsString();
                if (UpdateChecker.isNewerVersion(latestVersion, currentVersion)) {
                    log.info("A new version (" + latestVersion + ") is available!");
                    log.info("Changelog: " + changelog);
                    log.info("Download it from: " + downloadUrl);
                } else {
                    log.info("No new version available.");
                }
            })).join();
        }
        catch (Exception e) {
            log.severe("Error checking for updates: " + e.getMessage());
        }
    }

    private static boolean isNewerVersion(String latestVersion, String currentVersion) {
        String[] latest = latestVersion.split("\\.");
        String[] current = currentVersion.split("\\.");
        for (int i = 0; i < Math.min(latest.length, current.length); ++i) {
            int currentPart;
            int latestPart = Integer.parseInt(latest[i]);
            if (latestPart > (currentPart = Integer.parseInt(current[i]))) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        return latest.length > current.length;
    }
}

