/*
 * Decompiled with CFR 0.152.
 */
package org.voidish.consoleFilter;

import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.voidish.consoleFilter.ConsoleFilter;

public class ConsoleFilterCommand
implements CommandExecutor {
    private final ConsoleFilter plugin;

    public ConsoleFilterCommand(ConsoleFilter plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subcommand;
        if (args.length == 0) {
            String version = this.plugin.getConfig().getString("version", "Unknown");
            sender.sendMessage("\u00a76ConsoleFilter \u00a7fis \u00a7aactive. \u00a7fVersion: \u00a7a" + version);
            sender.sendMessage("\u00a76Usage: /ConsoleFilter <help|reload>");
            return true;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("consolefilter.reload")) {
                    sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                    return true;
                }
                this.plugin.reloadConfig();
                this.plugin.scheduleFilteredMessagesCountTask();
                sender.sendMessage("\u00a7aConsoleFilter configuration reloaded!");
                if (!(sender instanceof Player)) break;
                Player player = (Player)sender;
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BELL, 15.0f, 1.0f);
                break;
            }
            case "help": {
                this.showHelp(sender);
                break;
            }
            default: {
                sender.sendMessage("\u00a7cUnknown subcommand. \u00a76Usage: /ConsoleFilter <reload|help>");
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage("\u00a76--- ConsoleFilter Plugin Commands ---");
        sender.sendMessage("\u00a76Commands:");
        sender.sendMessage("\u00a76/ConsoleFilter reload \u00a79- Reload the plugin configuration.");
        sender.sendMessage("\u00a76/ConsoleFilter help \u00a79- Show this help message.");
    }
}

