/*
 * Decompiled with CFR 0.152.
 */
package org.voidish.consoleFilter;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.voidish.consoleFilter.ConsoleFilterCommand;
import org.voidish.consoleFilter.CustomLogFilter;
import org.voidish.consoleFilter.Metrics;
import org.voidish.consoleFilter.UpdateChecker;

public final class ConsoleFilter
extends JavaPlugin {
    private static Logger logger;
    private int filteredMessageCount = 0;
    private Map<String, Integer> filteredCountPerMessage = new HashMap<String, Integer>();
    private File dataFile;
    private FileConfiguration dataConfig;
    private BukkitTask scheduledTask;
    private int currentIntervalMinutes = -1;

    public void onEnable() {
        final UpdateChecker updateChecker = new UpdateChecker(this);
        boolean checkForUpdates = this.getConfig().getBoolean("Check-For-Updates", true);
        boolean outputFilteredMessagesCount = this.getConfig().getBoolean("Output-Filtered-Messages-Count-To-Console", true);
        logger = this.getLogger();
        logger.setLevel(Level.ALL);
        this.saveDefaultConfig();
        this.setupFilteredMessagePersistenceDataFile();
        this.updateConfig();
        this.saveConfig();
        this.hideConsoleMessages();
        this.getCommand("consolefilter").setExecutor((CommandExecutor)new ConsoleFilterCommand(this));
        int pluginId = 24225;
        Metrics metrics = new Metrics((Plugin)this, pluginId);
        if (checkForUpdates) {
            logger.info("Scheduling Update Checker ...");
            new BukkitRunnable(this){
                final /* synthetic */ ConsoleFilter this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    this.this$0.getServer().getScheduler().runTask((Plugin)this.this$0, new Runnable(){

                        @Override
                        public void run() {
                            updateChecker.checkForUpdates();
                        }
                    });
                }
            }.runTaskTimer((Plugin)this, 0L, 1728000L);
            logger.info("Update Checker Scheduled ...");
        }
        if (outputFilteredMessagesCount) {
            this.scheduleFilteredMessagesCountTask();
        }
        logger.info("ConsoleFilter enabled...");
    }

    public void onDisable() {
        boolean saveFilteredCount = this.getConfig().getBoolean("Save-Filtered-Count", true);
        if (saveFilteredCount) {
            if (this.getDataConfig().isInt("Filtered-Messages-Count")) {
                int oldTotal = this.getDataConfig().getInt("Filtered-Messages-Count");
                this.getDataConfig().set("Filtered-Messages-Count", null);
                int currentTotal = this.getDataConfig().getInt("Filtered-Messages-Count.Total", 0);
                this.getDataConfig().set("Filtered-Messages-Count.Total", (Object)(currentTotal + oldTotal));
            }
            int existingTotal = this.getDataConfig().getInt("Filtered-Messages-Count.Total", 0);
            this.getDataConfig().set("Filtered-Messages-Count.Total", (Object)(existingTotal + this.getFilteredMessageCount()));
            for (Map.Entry<String, Integer> entry : this.filteredCountPerMessage.entrySet()) {
                String keyword = entry.getKey().replace(".", "");
                int newCount = entry.getValue();
                String path = "Filtered-Messages-Count." + keyword;
                int existingCount = this.getDataConfig().getInt(path + ".Count", 0);
                int totalCount = existingCount + newCount;
                this.getDataConfig().set(path + ".Count", (Object)totalCount);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String lastSaveDate = dateFormat.format(new Date());
            this.getDataConfig().set("Last-Save-Date", (Object)lastSaveDate);
            this.saveDataFile();
        }
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        HandlerList.unregisterAll((Plugin)this);
        logger.info("ConsoleFilter plugin has been disabled.");
    }

    private void setupFilteredMessagePersistenceDataFile() {
        File pluginDataFolder = this.getDataFolder();
        if (!pluginDataFolder.exists()) {
            pluginDataFolder.mkdirs();
        }
        this.dataFile = new File(pluginDataFolder, "filteredMessagesCount.yml");
        if (!this.dataFile.exists()) {
            try {
                if (this.dataFile.createNewFile()) {
                    logger.info("Created new filteredMessagesCount.yml file.");
                }
            }
            catch (IOException e) {
                logger.severe("Could not create filteredMessagesCount.yml file: " + e.getMessage());
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
    }

    public void saveDataFile() {
        try {
            this.dataConfig.save(this.dataFile);
            logger.info("Filtered message count and last save date updated in FilteredMessagesCount.yml");
        }
        catch (IOException e) {
            logger.severe("Could not save filteredMessagesCount.yml file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public FileConfiguration getDataConfig() {
        return this.dataConfig;
    }

    public void updateConfig() {
        String currentVersion;
        FileConfiguration currentConfig = this.getConfig();
        YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(this.getResource("config.yml")));
        boolean changesMade = false;
        StringBuilder addedValues = new StringBuilder("Added: ");
        StringBuilder updatedValues = new StringBuilder("Updated: ");
        StringBuilder removedValues = new StringBuilder("Removed: ");
        String defaultVersion = defaultConfig.getString("version");
        if (!defaultVersion.equals(currentVersion = currentConfig.getString("version"))) {
            currentConfig.set("version", (Object)defaultVersion);
            updatedValues.append("version, ");
            changesMade = true;
        }
        for (String key : defaultConfig.getKeys(true)) {
            if (key.contains(".") || currentConfig.isSet(key)) continue;
            currentConfig.set(key, defaultConfig.get(key));
            addedValues.append(key).append(", ");
            changesMade = true;
        }
        Set currentKeys = currentConfig.getKeys(true);
        for (String currentKey : currentKeys) {
            if (currentKey.contains(".") || defaultConfig.isSet(currentKey)) continue;
            currentConfig.set(currentKey, null);
            removedValues.append(currentKey).append(", ");
            changesMade = true;
        }
        if (changesMade) {
            this.saveConfig();
            logger.info("[Configuration updated]");
            if (addedValues.length() > 7) {
                logger.info(addedValues.toString());
            }
            if (updatedValues.length() > 8) {
                logger.info(updatedValues.toString());
            }
            if (removedValues.length() > 8) {
                logger.info(removedValues.toString());
            }
        } else {
            logger.info("Configuration is up to date.");
        }
    }

    public static Logger getPluginLogger() {
        return logger;
    }

    public void hideConsoleMessages() {
        org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        rootLogger.addFilter((Filter)new CustomLogFilter(this));
    }

    public int getFilteredMessageCount() {
        return this.filteredMessageCount;
    }

    public void setFilteredMessageCount(int filteredMessageCount) {
        this.filteredMessageCount = filteredMessageCount;
    }

    public int getFilteredCountPerMessage(String key) {
        return this.filteredCountPerMessage.getOrDefault(key, 0);
    }

    public void setFilteredCountPerMessage(String key, int count) {
        this.filteredCountPerMessage.put(key, count);
    }

    public void scheduleFilteredMessagesCountTask() {
        int newIntervalMinutes = this.getConfig().getInt("Output-Filtered-Messages-Count-Interval", 10);
        if (newIntervalMinutes <= 0) {
            logger.warning("Invalid interval value in config.yml ('Output-Filtered-Messages-Count-Interval'). It must be a positive number. Defaulting to 10 minutes.");
            newIntervalMinutes = 10;
        }
        if (newIntervalMinutes == this.currentIntervalMinutes) {
            return;
        }
        this.currentIntervalMinutes = newIntervalMinutes;
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
            logger.info("Detected interval change. Previous Filter Messages Count task canceled.");
        }
        int intervalTicks = newIntervalMinutes * 60 * 20;
        logger.info("Scheduling the count output for filtered messages ...");
        this.scheduledTask = new BukkitRunnable(){

            public void run() {
                logger.info("Total filtered messages so far: " + ConsoleFilter.this.getFilteredMessageCount());
            }
        }.runTaskTimer((Plugin)this, 600L, (long)intervalTicks);
        logger.info("Filter Messages Count Console Output Scheduled. Runs every " + newIntervalMinutes + " minutes.");
    }
}

