/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.spongecakes.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeConverter {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\d+)");
    private static final Pattern LETTER_PATTERN = Pattern.compile("[A-Za-z]");

    public static String convertToReadableTime(long time) {
        return TimeConverter.convertToReadableTime(time, false, new String[0]);
    }

    public static String convertToReadableTime(long time, boolean longPrefixes, String ... excludedTimes) {
        if (time <= 0L) {
            return "Forever";
        }
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time);
        seconds -= seconds / 60L * 60L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time);
        minutes -= minutes / 60L * 60L;
        long hours = TimeUnit.MILLISECONDS.toHours(time);
        hours -= hours / 24L * 24L;
        long days = TimeUnit.MILLISECONDS.toDays(time);
        long months = days / 30L;
        days -= days / 30L * 30L;
        long weeks = days / 7L;
        days -= days / 7L * 7L;
        long years = months / 12L;
        months -= months / 12L * 12L;
        StringBuilder message = new StringBuilder();
        if (years > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("year"))) {
            message.append(years).append(TimeAbbreviation.YEAR.getPrefix(longPrefixes) + (longPrefixes ? (years > 1L ? "s" : "") : "")).append(" ");
        }
        if (months > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("month"))) {
            message.append(months).append(TimeAbbreviation.MONTH.getPrefix(longPrefixes) + (longPrefixes ? (months > 1L ? "s" : "") : "")).append(" ");
        }
        if (weeks > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("weeks"))) {
            message.append(weeks).append(TimeAbbreviation.WEEK.getPrefix(longPrefixes) + (longPrefixes ? (weeks > 1L ? "s" : "") : "")).append(" ");
        }
        if (days > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("days"))) {
            message.append(days).append(TimeAbbreviation.DAY.getPrefix(longPrefixes) + (longPrefixes ? (days > 1L ? "s" : "") : "")).append(" ");
        }
        if (hours > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("hours"))) {
            message.append(hours).append(TimeAbbreviation.HOUR.getPrefix(longPrefixes) + (longPrefixes ? (hours > 1L ? "s" : "") : "")).append(" ");
        }
        if (minutes > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("minutes"))) {
            message.append(minutes).append(TimeAbbreviation.MINUTE.getPrefix(longPrefixes) + (longPrefixes ? (minutes > 1L ? "s" : "") : "")).append(" ");
        }
        if (seconds > 0L && Arrays.stream(excludedTimes).noneMatch(s -> s.equalsIgnoreCase("seconds"))) {
            message.append(seconds).append(TimeAbbreviation.SECOND.getPrefix(longPrefixes) + (longPrefixes ? (seconds > 1L ? "s" : "") : ""));
        }
        return message.toString().trim().isEmpty() ? "0s" : message.toString().trim();
    }

    public static long convert(String combindedArgs) {
        String[] args = combindedArgs.split(" ");
        long time = 0L;
        for (String arg : args) {
            if (!arg.matches("((\\d+)[A-Za-z])")) continue;
            Matcher numberMatcher = NUMBER_PATTERN.matcher(arg);
            numberMatcher.find();
            Matcher letterMatcher = LETTER_PATTERN.matcher(arg);
            letterMatcher.find();
            long tempTime = Long.valueOf(numberMatcher.group(0));
            TimeAbbreviation abbreviation = TimeConverter.getAbbreviation(letterMatcher.group(0));
            time += abbreviation.getTime(tempTime);
        }
        return time;
    }

    private static TimeAbbreviation getAbbreviation(String data) {
        for (TimeAbbreviation abbreviation : TimeAbbreviation.values()) {
            for (String prefix : abbreviation.getPrefix()) {
                if (!data.equalsIgnoreCase(prefix)) continue;
                return abbreviation;
            }
        }
        return null;
    }

    public static enum TimeAbbreviation {
        SECOND(1L, "s", " Second"),
        MINUTE(60L, "m", " Minute"),
        HOUR(3600L, "h", " Hour"),
        DAY(86400L, "d", " Day"),
        WEEK(604800L, "w", " Week"),
        MONTH(2592000L, "mh", " Month"),
        YEAR(31556952L, "y", " Year"),
        INFINITE(-1L, "f", "Forever");

        String[] prefix;
        long multiplier;

        private TimeAbbreviation(long multiplier, String ... prefix) {
            this.prefix = prefix;
            this.multiplier = multiplier;
        }

        public String[] getPrefix() {
            return this.prefix;
        }

        public long getTime(long time) {
            if (this.multiplier == -1L) {
                return -1L;
            }
            return time * this.multiplier * 1000L;
        }

        public String getPrefix(boolean longPrefix) {
            return longPrefix ? this.prefix[1] : this.prefix[0];
        }
    }
}

