/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.spongecakes.util;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bitbylogic.spongecakes.SpongeCakes;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class SpongeUtils {
    private static final Pattern hexColorExtractor = Pattern.compile("#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})");

    public static ItemStack getItemStackFromConfig(ConfigurationSection section) {
        ItemMeta updatedMeta;
        ConfigurationSection potionSection;
        if (section.getString("Material", "BARRIER").equalsIgnoreCase("CONDENSED_SPONGE")) {
            return SpongeCakes.getInstance().getCondensedSponge();
        }
        int amount = section.getInt("Amount", 1);
        ItemStack stack = new ItemStack(Material.valueOf((String)section.getString("Material", "BARRIER")), amount);
        ItemMeta meta = stack.getItemMeta();
        if (meta == null) {
            return null;
        }
        if (section.getString("Name") != null) {
            meta.setDisplayName(SpongeUtils.color(section.getString("Name")));
        }
        ArrayList lore = Lists.newArrayList();
        section.getStringList("Lore").forEach(string -> lore.add(SpongeUtils.color(string)));
        meta.setLore((List)lore);
        section.getStringList("Flags").forEach(flag -> meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.toUpperCase())}));
        if (section.getBoolean("Unbreakable")) {
            meta.setUnbreakable(true);
        }
        if (section.getBoolean("Glow")) {
            meta.addEnchant(Enchantment.UNBREAKING, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        stack.setItemMeta(meta);
        if (stack.getType().name().startsWith("LEATHER_") && section.getString("Dye-Color") != null) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)stack.getItemMeta();
            Color color = ChatColor.of((String)section.getString("Dye-Color")).getColor();
            leatherArmorMeta.setColor(org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            stack.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        if ((stack.getType() == Material.SPLASH_POTION || stack.getType() == Material.POTION) && (potionSection = section.getConfigurationSection("Potion-Data")) != null) {
            boolean vanilla = potionSection.getBoolean("Vanilla", false);
            PotionMeta potionMeta = (PotionMeta)stack.getItemMeta();
            String potionType = potionSection.getString("Type", "POISON");
            if (vanilla) {
                potionMeta.setBasePotionType(PotionType.valueOf((String)potionType));
            } else {
                potionMeta.addCustomEffect(new PotionEffect(PotionEffectType.getByName((String)potionType), potionSection.getInt("Duration", 20), potionSection.getInt("Amplifier", 1) - 1), true);
            }
            stack.setItemMeta((ItemMeta)potionMeta);
        }
        if (stack.getType() == Material.TIPPED_ARROW) {
            PotionMeta potionMeta = (PotionMeta)stack.getItemMeta();
            potionMeta.setBasePotionType(PotionType.valueOf((String)section.getString("Arrow-Type", "POISON")));
            stack.setItemMeta((ItemMeta)potionMeta);
        }
        if (section.getString("Skull-Name") != null && stack.getType() == Material.PLAYER_HEAD) {
            SkullMeta skullMeta = (SkullMeta)stack.getItemMeta();
            skullMeta.setOwner(section.getString("Skull-Name", "Notch"));
            stack.setItemMeta((ItemMeta)skullMeta);
        }
        if (section.getInt("Model-Data") != 0) {
            updatedMeta = stack.getItemMeta();
            updatedMeta.setCustomModelData(Integer.valueOf(section.getInt("Model-Data")));
            stack.setItemMeta(updatedMeta);
        }
        updatedMeta = stack.getItemMeta();
        section.getStringList("Enchantments").forEach(enchant -> {
            String[] data = enchant.split(":");
            NamespacedKey key = NamespacedKey.minecraft((String)data[0].trim());
            Enchantment enchantment = Enchantment.getByKey((NamespacedKey)key);
            int level = 0;
            try {
                level = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                Bukkit.getLogger().warning(String.format("[SpongeCakes]: Skipped enchantment '%s', invalid level.", enchant));
                return;
            }
            if (enchantment == null) {
                Bukkit.getLogger().warning(String.format("[SpongeCakes]: Skipped enchantment '%s', invalid enchant.", enchant));
                return;
            }
            updatedMeta.addEnchant(enchantment, level, true);
        });
        stack.setItemMeta(updatedMeta);
        return stack;
    }

    public static String color(String message) {
        String coloredMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Matcher matcher = hexColorExtractor.matcher(coloredMessage);
        while (matcher.find()) {
            String hexColor = matcher.group();
            coloredMessage = coloredMessage.replace(hexColor, ChatColor.of((String)hexColor).toString());
        }
        return coloredMessage;
    }

    public static String locationToString(Location location, String separator) {
        return location.getWorld().getName() + separator + location.getBlockX() + separator + location.getBlockY() + separator + location.getBlockZ();
    }

    public static boolean hasPersistentData(Location location) {
        return location.getChunk().getPersistentDataContainer().has(new NamespacedKey((Plugin)SpongeCakes.getInstance(), SpongeUtils.locationToString(location, "._.")), PersistentDataType.TAG_CONTAINER);
    }

    public static PersistentDataContainer getPersistentData(Location location, boolean create) {
        NamespacedKey locationKey = new NamespacedKey((Plugin)SpongeCakes.getInstance(), SpongeUtils.locationToString(location, "._."));
        Chunk chunk = location.getChunk();
        if (!chunk.getPersistentDataContainer().has(locationKey, PersistentDataType.TAG_CONTAINER)) {
            if (!create) {
                return null;
            }
            chunk.getPersistentDataContainer().set(locationKey, PersistentDataType.TAG_CONTAINER, (Object)chunk.getPersistentDataContainer().getAdapterContext().newPersistentDataContainer());
        }
        return (PersistentDataContainer)chunk.getPersistentDataContainer().get(locationKey, PersistentDataType.TAG_CONTAINER);
    }

    public static void deletePersistentData(Location location) {
        NamespacedKey locationKey = new NamespacedKey((Plugin)SpongeCakes.getInstance(), SpongeUtils.locationToString(location, "._."));
        Chunk chunk = location.getChunk();
        if (!chunk.getPersistentDataContainer().has(locationKey, PersistentDataType.TAG_CONTAINER)) {
            return;
        }
        chunk.getPersistentDataContainer().remove(locationKey);
    }

    public static void savePersistentData(Location location, PersistentDataContainer container) {
        location.getChunk().getPersistentDataContainer().set(new NamespacedKey((Plugin)SpongeCakes.getInstance(), SpongeUtils.locationToString(location, "._.")), PersistentDataType.TAG_CONTAINER, (Object)container);
    }

    public static int vanillaDrain(Player player, Location location, int maxBlocks) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(location.getBlock());
        int i = 0;
        while (!queue.isEmpty()) {
            Block originalBlock = (Block)queue.poll();
            for (BlockFace face : BlockFace.values()) {
                Waterlogged waterloggedData;
                if (face == BlockFace.SELF || i > maxBlocks) break;
                Block relativeBlock = originalBlock.getRelative(face);
                BlockData blockData = relativeBlock.getBlockData();
                if (SpongeCakes.getInstance().getProtectionChecks().stream().anyMatch(check -> !check.canBreak(player, relativeBlock.getLocation())) || !SpongeUtils.isDrainableBlock(relativeBlock)) continue;
                if (blockData instanceof Waterlogged && (waterloggedData = (Waterlogged)blockData).isWaterlogged()) {
                    waterloggedData.setWaterlogged(false);
                    relativeBlock.setBlockData((BlockData)waterloggedData);
                    relativeBlock.getState().update(false, true);
                    ++i;
                    queue.add(relativeBlock);
                    continue;
                }
                relativeBlock.setType(Material.AIR);
                ++i;
                queue.add(relativeBlock);
            }
            if (i <= maxBlocks) continue;
            break;
        }
        return i;
    }

    public static List<Block> drainInRadius(Location location, int radius) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (location == null || location.getWorld() == null) {
            return blocks;
        }
        World world = location.getWorld();
        int bx = location.getBlockX();
        int by = location.getBlockY();
        int bz = location.getBlockZ();
        for (int x = bx - radius; x <= bx + radius; ++x) {
            for (int y = by - radius; y <= by + radius; ++y) {
                for (int z = bz - radius; z <= bz + radius; ++z) {
                    Block block;
                    double distance = (bx - x) * (bx - x) + (bz - z) * (bz - z) + (by - y) * (by - y);
                    if (distance >= (double)(radius * radius) && distance >= (double)((radius - 1) * (radius - 1)) || !SpongeUtils.isDrainableBlock(block = world.getBlockAt(x, y, z))) continue;
                    blocks.add(block);
                }
            }
        }
        return blocks;
    }

    private static boolean isDrainableBlock(Block block) {
        Waterlogged waterlogged;
        BlockData blockData;
        return block.getType() == Material.WATER || (blockData = block.getBlockData()) instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged() || block.getType() == Material.SEAGRASS || block.getType() == Material.TALL_SEAGRASS || block.getType() == Material.KELP || block.getType() == Material.KELP_PLANT;
    }
}

