/*
 * Decompiled with CFR 0.152.
 */
package net.bitbylogic.spongecakes;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bitbylogic.spongecakes.checks.ProtectionCheck;
import net.bitbylogic.spongecakes.checks.impl.GriefPreventionCheck;
import net.bitbylogic.spongecakes.checks.impl.WorldGuardCheck;
import net.bitbylogic.spongecakes.command.SpongeCakesCommand;
import net.bitbylogic.spongecakes.listener.SpongeListener;
import net.bitbylogic.spongecakes.updatechecker.UpdateCheckSource;
import net.bitbylogic.spongecakes.updatechecker.UpdateChecker;
import net.bitbylogic.spongecakes.updatechecker.UserAgentBuilder;
import net.bitbylogic.spongecakes.util.SpongeUtils;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.ServerOperator;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SpongeCakes
extends JavaPlugin {
    private static SpongeCakes instance;
    private final List<ProtectionCheck> protectionChecks = new ArrayList<ProtectionCheck>();
    private final List<NamespacedKey> recipeKeys = new ArrayList<NamespacedKey>();
    private ItemStack condensedSponge;
    private ItemStack spongeCake;
    private ItemStack condensedSpongeCake;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadRecipes();
        this.getCommand("spongecakes").setExecutor((CommandExecutor)new SpongeCakesCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new SpongeListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().isPluginEnabled("GriefPrevention")) {
            this.protectionChecks.add(new GriefPreventionCheck());
        }
        if (this.getServer().getPluginManager().isPluginEnabled("WorldGuard")) {
            this.protectionChecks.add(new WorldGuardCheck());
        }
        new UpdateChecker(this, UpdateCheckSource.SPIGOT, "117722").setNotifyRequesters(false).setNotifyOpsOnJoin(false).setUserAgent(UserAgentBuilder.getDefaultUserAgent()).checkEveryXHours(12.0).onSuccess((commandSenders, latestVersion) -> {
            String messagePrefix = "&8[&eSponge Cakes&8] ";
            String currentVersion = this.getDescription().getVersion();
            if (currentVersion.equalsIgnoreCase((String)latestVersion)) {
                String updateMessage = SpongeUtils.color(messagePrefix + "&aYou are using the latest version of SpongeCakes!");
                Bukkit.getConsoleSender().sendMessage(updateMessage);
                Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(player -> player.sendMessage(updateMessage));
                return;
            }
            List<String> updateMessages = List.of(SpongeUtils.color(messagePrefix + "&cYour version of SpongeCakes is outdated!"), SpongeUtils.color(String.format(messagePrefix + "&cYou are using %s, latest is %s!", currentVersion, latestVersion)), SpongeUtils.color(messagePrefix + "&cDownload latest here:"), SpongeUtils.color("&6https://www.spigotmc.org/resources/spongecakes.117722/"));
            Bukkit.getConsoleSender().sendMessage(updateMessages.toArray(new String[0]));
            Bukkit.getOnlinePlayers().stream().filter(ServerOperator::isOp).forEach(player -> player.sendMessage(updateMessages.toArray(new String[0])));
        }).onFail((commandSenders, e) -> {}).checkNow();
    }

    public void onDisable() {
    }

    public void loadRecipes() {
        this.recipeKeys.clear();
        this.loadRecipe("Condensed-Sponge").ifPresent(item -> {
            this.condensedSponge = item;
        });
        this.loadRecipe("Sponge-Cake").ifPresent(item -> {
            this.spongeCake = item;
        });
        this.loadRecipe("Condensed-Sponge-Cake").ifPresent(item -> {
            this.condensedSpongeCake = item;
        });
    }

    private Optional<ItemStack> loadRecipe(String recipeId) {
        ConfigurationSection keySection = this.getConfig().getConfigurationSection(recipeId);
        if (keySection == null) {
            return Optional.empty();
        }
        ConfigurationSection recipeSection = keySection.getConfigurationSection("Recipe");
        if (recipeSection == null) {
            return Optional.empty();
        }
        ConfigurationSection itemSection = keySection.getConfigurationSection("Item");
        if (itemSection == null) {
            return Optional.empty();
        }
        ItemStack recipeResult = SpongeUtils.getItemStackFromConfig(itemSection);
        if (recipeResult == null) {
            return Optional.empty();
        }
        ItemMeta meta = recipeResult.getItemMeta();
        if (meta == null) {
            return Optional.empty();
        }
        NamespacedKey recipeKey = new NamespacedKey((Plugin)this, recipeId);
        if (Bukkit.getRecipe((NamespacedKey)recipeKey) != null) {
            Bukkit.removeRecipe((NamespacedKey)recipeKey);
        }
        ArrayList lore = new ArrayList();
        meta.getLore().forEach(line -> lore.add(line.replace("%max%", "" + this.getConfig().getInt("Condensed-Sponge.Max-Absorbed", 576)).replace("%base-radius%", "" + this.getConfig().getInt("Sponge-Cake.Absorb-Radius", 5)).replace("%condensed-radius%", "" + this.getConfig().getInt("Condensed-Sponge-Cake.Absorb-Radius", 10))));
        meta.setLore(lore);
        meta.getPersistentDataContainer().set(recipeKey, PersistentDataType.BOOLEAN, (Object)true);
        recipeResult.setItemMeta(meta);
        if (!recipeSection.getBoolean("Enabled")) {
            return Optional.empty();
        }
        ConfigurationSection ingredientsSection = recipeSection.getConfigurationSection("Ingredients");
        String recipeType = recipeSection.getString("Type", "SHAPELESS");
        if (ingredientsSection == null) {
            return Optional.empty();
        }
        switch (recipeType) {
            case "SHAPED": {
                List shape = recipeSection.getStringList("Shape");
                ShapedRecipe shapedRecipe = new ShapedRecipe(recipeKey, recipeResult).shape(shape.toArray(new String[0]));
                for (String ingredientKey : ingredientsSection.getKeys(false)) {
                    ItemStack ingredient;
                    ConfigurationSection ingredientItemSection = ingredientsSection.getConfigurationSection(ingredientKey);
                    if (ingredientItemSection == null || (ingredient = SpongeUtils.getItemStackFromConfig(ingredientItemSection)) == null) continue;
                    shapedRecipe.setIngredient(ingredientKey.charAt(0), (RecipeChoice)new RecipeChoice.ExactChoice(ingredient));
                }
                Bukkit.addRecipe((Recipe)shapedRecipe);
                break;
            }
            case "SHAPELESS": {
                ShapelessRecipe shapelessRecipe = new ShapelessRecipe(recipeKey, recipeResult);
                for (String ingredientKey : ingredientsSection.getKeys(false)) {
                    ItemStack ingredient;
                    ConfigurationSection ingredientItemSection = ingredientsSection.getConfigurationSection(ingredientKey);
                    if (ingredientItemSection == null || (ingredient = SpongeUtils.getItemStackFromConfig(ingredientItemSection)) == null) continue;
                    shapelessRecipe.addIngredient((RecipeChoice)new RecipeChoice.ExactChoice(ingredient));
                }
                Bukkit.addRecipe((Recipe)shapelessRecipe);
                break;
            }
        }
        this.recipeKeys.add(recipeKey);
        return Optional.of(recipeResult);
    }

    public List<ProtectionCheck> getProtectionChecks() {
        return this.protectionChecks;
    }

    public List<NamespacedKey> getRecipeKeys() {
        return this.recipeKeys;
    }

    public ItemStack getCondensedSponge() {
        return this.condensedSponge;
    }

    public ItemStack getSpongeCake() {
        return this.spongeCake;
    }

    public ItemStack getCondensedSpongeCake() {
        return this.condensedSpongeCake;
    }

    public static SpongeCakes getInstance() {
        return instance;
    }
}

