/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bskyblock.generators;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.Vector;
import org.bukkit.util.noise.PerlinOctaveGenerator;
import world.bentobox.bskyblock.BSkyBlock;

public class ChunkGeneratorWorld
extends ChunkGenerator {
    private final BSkyBlock addon;
    private final Random rand = new Random();
    private final Map<Vector, Material> roofChunk = new HashMap<Vector, Material>();

    public ChunkGeneratorWorld(BSkyBlock addon) {
        this.addon = addon;
        this.makeNetherRoof();
    }

    public boolean shouldGenerateStructures() {
        return false;
    }

    public ChunkGenerator.ChunkData generateChunks(World world) {
        ChunkGenerator.ChunkData result = this.createChunkData(world);
        if (world.getEnvironment().equals((Object)World.Environment.NORMAL) && this.addon.getSettings().getSeaHeight() > 0) {
            result.setRegion(0, world.getMinHeight(), 0, 16, this.addon.getSettings().getSeaHeight() + 1, 16, Material.WATER);
        }
        if (world.getEnvironment().equals((Object)World.Environment.NETHER) && this.addon.getSettings().isNetherRoof()) {
            this.roofChunk.forEach((k, v) -> result.setBlock(k.getBlockX(), world.getMaxHeight() + k.getBlockY(), k.getBlockZ(), v));
        }
        return result;
    }

    public ChunkGenerator.ChunkData generateChunkData(World world, Random random, int chunkX, int chunkZ, ChunkGenerator.BiomeGrid biomeGrid) {
        this.setBiome(world, biomeGrid);
        return this.generateChunks(world);
    }

    private void setBiome(World world, ChunkGenerator.BiomeGrid biomeGrid) {
        Biome biome = world.getEnvironment() == World.Environment.NORMAL ? this.addon.getSettings().getDefaultBiome() : (world.getEnvironment() == World.Environment.NETHER ? this.addon.getSettings().getDefaultNetherBiome() : this.addon.getSettings().getDefaultEndBiome());
        for (int x = 0; x < 16; x += 4) {
            for (int z = 0; z < 16; z += 4) {
                for (int y = world.getMinHeight(); y < world.getMaxHeight(); y += 4) {
                    biomeGrid.setBiome(x, y, z, biome);
                }
            }
        }
    }

    public boolean canSpawn(World world, int x, int z) {
        return true;
    }

    public boolean shouldGenerateMobs(WorldInfo worldInfo, Random random, int chunkX, int chunkZ) {
        return true;
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        return Collections.emptyList();
    }

    private void makeNetherRoof() {
        this.rand.setSeed(System.currentTimeMillis());
        PerlinOctaveGenerator gen = new PerlinOctaveGenerator((long)((double)this.rand.nextLong() * this.rand.nextGaussian()), 8);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                double r;
                int y;
                this.setBlock(x, -1, z, Material.BEDROCK);
                for (y = 2; y < 5; ++y) {
                    r = gen.noise((double)x, (double)(-y), (double)z, 0.5, 0.5);
                    if (!(r > 0.0)) continue;
                    this.setBlock(x, -y, z, Material.BEDROCK);
                }
                for (y = 5; y < 8; ++y) {
                    r = gen.noise((double)x, (double)(-y), (double)z, 0.5, 0.5);
                    if (r > 0.0) {
                        this.setBlock(x, -y, z, Material.NETHERRACK);
                        continue;
                    }
                    this.setBlock(x, -y, z, Material.AIR);
                }
                double r2 = gen.noise((double)x, -8.0, (double)z, (double)this.rand.nextFloat(), (double)this.rand.nextFloat());
                if (r2 > 0.5) {
                    switch (this.rand.nextInt(4)) {
                        case 1: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                            if (x >= 14 || z >= 14) break;
                            this.setBlock(x + 1, -8, z + 1, Material.GLOWSTONE);
                            this.setBlock(x + 2, -8, z + 2, Material.GLOWSTONE);
                            this.setBlock(x + 1, -8, z + 2, Material.GLOWSTONE);
                            this.setBlock(x + 1, -8, z + 2, Material.GLOWSTONE);
                            break;
                        }
                        case 2: {
                            for (int i = 0; i < this.rand.nextInt(10); ++i) {
                                this.setBlock(x, -8 - i, z, Material.GLOWSTONE);
                            }
                            break;
                        }
                        case 3: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                            if (x <= 3 || z <= 3) break;
                            for (int xx = 0; xx < 3; ++xx) {
                                for (int zz = 0; zz < 3; ++zz) {
                                    this.setBlock(x - xx, -8 - this.rand.nextInt(2), z - xx, Material.GLOWSTONE);
                                }
                            }
                            break;
                        }
                        default: {
                            this.setBlock(x, -8, z, Material.GLOWSTONE);
                        }
                    }
                    this.setBlock(x, -8, z, Material.GLOWSTONE);
                    continue;
                }
                this.setBlock(x, -8, z, Material.AIR);
            }
        }
    }

    private void setBlock(int x, int y, int z, Material m) {
        this.roofChunk.put(new Vector(x, y, z), m);
    }
}

