/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bskyblock;

import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.DefaultAdminCommand;
import world.bentobox.bentobox.api.commands.island.DefaultPlayerCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bskyblock.Settings;
import world.bentobox.bskyblock.commands.IslandAboutCommand;
import world.bentobox.bskyblock.generators.ChunkGeneratorWorld;

public class BSkyBlock
extends GameModeAddon
implements Listener {
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    private Settings settings;
    private ChunkGeneratorWorld chunkGenerator;
    private final Config<Settings> configObject = new Config((Addon)this, Settings.class);

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
        this.chunkGenerator = this.settings.isUseOwnGenerator() ? null : new ChunkGeneratorWorld(this);
        this.playerCommand = new DefaultPlayerCommand(this){

            public void setup() {
                super.setup();
                new IslandAboutCommand((CompositeCommand)this);
            }
        };
        this.adminCommand = new DefaultAdminCommand(this){};
    }

    private boolean loadSettings() {
        this.settings = (Settings)this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("BSkyBlock settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return false;
        }
        return true;
    }

    public void onEnable() {
        this.registerListener(this);
    }

    public void onDisable() {
    }

    public void onReload() {
        if (this.loadSettings()) {
            this.log("Reloaded BSkyBlock settings");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        if (this.getServer().getWorld(worldName) == null) {
            this.log("Creating BSkyBlock world ...");
        }
        this.islandWorld = this.getWorld(worldName, World.Environment.NORMAL, this.chunkGenerator);
        if (this.settings.isNetherGenerate()) {
            if (this.getServer().getWorld(worldName + NETHER) == null) {
                this.log("Creating BSkyBlock's Nether...");
            }
            World world = this.netherWorld = this.settings.isNetherIslands() ? this.getWorld(worldName, World.Environment.NETHER, this.chunkGenerator) : this.getWorld(worldName, World.Environment.NETHER, null);
        }
        if (this.settings.isEndGenerate()) {
            if (this.getServer().getWorld(worldName + THE_END) == null) {
                this.log("Creating BSkyBlock's End World...");
            }
            this.endWorld = this.settings.isEndIslands() ? this.getWorld(worldName, World.Environment.THE_END, this.chunkGenerator) : this.getWorld(worldName, World.Environment.THE_END, null);
        }
    }

    private World getWorld(String worldName2, World.Environment env, ChunkGeneratorWorld chunkGenerator2) {
        World w;
        worldName2 = env.equals((Object)World.Environment.NETHER) ? (String)worldName2 + NETHER : worldName2;
        worldName2 = env.equals((Object)World.Environment.THE_END) ? (String)worldName2 + THE_END : worldName2;
        WorldCreator wc = WorldCreator.name((String)worldName2).environment(env);
        World world = w = this.settings.isUseOwnGenerator() ? wc.createWorld() : wc.generator((ChunkGenerator)chunkGenerator2).createWorld();
        if (w != null && this.getSettings() != null) {
            if (this.getSettings().getSpawnLimitMonsters() > 0) {
                w.setSpawnLimit(SpawnCategory.MONSTER, this.getSettings().getSpawnLimitMonsters());
            }
            if (this.getSettings().getSpawnLimitAmbient() > 0) {
                w.setSpawnLimit(SpawnCategory.AMBIENT, this.getSettings().getSpawnLimitAmbient());
            }
            if (this.getSettings().getSpawnLimitAnimals() > 0) {
                w.setSpawnLimit(SpawnCategory.ANIMAL, this.getSettings().getSpawnLimitAnimals());
            }
            if (this.getSettings().getSpawnLimitWaterAnimals() > 0) {
                w.setSpawnLimit(SpawnCategory.WATER_ANIMAL, this.getSettings().getSpawnLimitWaterAnimals());
            }
            if (this.getSettings().getTicksPerAnimalSpawns() > 0) {
                w.setTicksPerSpawns(SpawnCategory.ANIMAL, this.getSettings().getTicksPerAnimalSpawns());
            }
            if (this.getSettings().getTicksPerMonsterSpawns() > 0) {
                w.setTicksPerSpawns(SpawnCategory.MONSTER, this.getSettings().getTicksPerMonsterSpawns());
            }
        }
        return w;
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.chunkGenerator;
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.configObject.saveConfigObject((Object)this.settings);
        }
    }

    public void allLoaded() {
        this.saveWorldSettings();
    }
}

