/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandInfo {
    private static final String XZ1 = "[xz1]";
    private static final String RANGE = "[range]";
    private final BentoBox plugin = BentoBox.getInstance();
    private final Island island;
    private final @Nullable UUID owner;
    private final World world;

    public IslandInfo(Island island) {
        this.island = island;
        this.owner = island.getOwner();
        this.world = island.getWorld();
    }

    public void showAdminInfo(User user, Addon addon) {
        user.sendMessage("commands.admin.info.title", new String[0]);
        user.sendMessage("commands.admin.info.island-uuid", "[uuid]", this.island.getUniqueId());
        if (this.owner == null) {
            user.sendMessage("commands.admin.info.unowned", new String[0]);
        } else {
            String formattedDate;
            user.sendMessage("commands.admin.info.owner", "[owner]", this.plugin.getPlayers().getName(this.owner), "[uuid]", this.owner.toString());
            long lastPlayed = Bukkit.getOfflinePlayer((UUID)this.owner).getLastSeen();
            try {
                String dateTimeFormat = this.plugin.getLocalesManager().get("commands.admin.info.last-login-date-time-format");
                formattedDate = new SimpleDateFormat(dateTimeFormat).format(new Date(lastPlayed));
            }
            catch (Exception ignored) {
                formattedDate = new Date(lastPlayed).toString();
            }
            user.sendMessage("commands.admin.info.last-login", "[date]", formattedDate);
            user.sendMessage("commands.admin.info.deaths", "[number]", String.valueOf(this.plugin.getPlayers().getDeaths(this.world, this.owner)));
            String resets = String.valueOf(this.plugin.getPlayers().getResets(this.world, this.owner));
            String total = this.plugin.getIWM().getResetLimit(this.world) < 0 ? "Unlimited" : String.valueOf(this.plugin.getIWM().getResetLimit(this.world));
            user.sendMessage("commands.admin.info.resets-left", "[number]", resets, "[total]", total);
            this.showMembers(user);
        }
        Vector location = this.island.getProtectionCenter().toVector();
        user.sendMessage("commands.admin.info.island-protection-center", "[xyz]", Util.xyz(location));
        user.sendMessage("commands.admin.info.island-center", "[xyz]", Util.xyz(this.island.getCenter().toVector()));
        user.sendMessage("commands.admin.info.island-coords", XZ1, Util.xyz(new Vector(this.island.getMinX(), 0, this.island.getMinZ())), "[xz2]", Util.xyz(new Vector(this.island.getMaxX(), 0, this.island.getMaxZ())));
        user.sendMessage("commands.admin.info.protection-range", RANGE, String.valueOf(this.island.getProtectionRange()));
        if (!this.island.getBonusRanges().isEmpty()) {
            user.sendMessage("commands.admin.info.protection-range-bonus-title", new String[0]);
        }
        this.island.getBonusRanges().forEach(brb -> {
            if (brb.getMessage().isBlank()) {
                user.sendMessage("commands.admin.info.protection-range-bonus", "[number]", String.valueOf(brb.getRange()));
            } else {
                user.sendMessage(brb.getMessage(), "[number]", String.valueOf(brb.getRange()));
            }
        });
        user.sendMessage("commands.admin.info.max-protection-range", RANGE, String.valueOf(this.island.getMaxEverProtectionRange()));
        user.sendMessage("commands.admin.info.protection-coords", XZ1, Util.xyz(new Vector(this.island.getMinProtectedX(), 0, this.island.getMinProtectedZ())), "[xz2]", Util.xyz(new Vector(this.island.getMaxProtectedX() - 1, 0, this.island.getMaxProtectedZ() - 1)));
        if (this.island.isSpawn()) {
            user.sendMessage("commands.admin.info.is-spawn", new String[0]);
        }
        if (!this.island.getBanned().isEmpty()) {
            user.sendMessage("commands.admin.info.banned-players", new String[0]);
            this.island.getBanned().forEach(u -> user.sendMessage("commands.admin.info.banned-format", "[name]", this.plugin.getPlayers().getName((UUID)u)));
        }
        if (this.island.isPurgeProtected()) {
            user.sendMessage("commands.admin.info.purge-protected", new String[0]);
        }
        this.island.getMetaData("bundle").ifPresent(mdv -> user.sendMessage("commands.admin.info.bundle", "[name]", mdv.asString()));
        IslandEvent.builder().island(this.island).location(this.island.getCenter()).reason(IslandEvent.Reason.INFO).involvedPlayer(user.getUniqueId()).addon(addon).admin(true).build();
    }

    public boolean showInfo(User user) {
        user.sendMessage("commands.admin.info.title", new String[0]);
        if (this.owner == null) {
            user.sendMessage("commands.admin.info.unowned", new String[0]);
        } else {
            user.sendMessage("commands.admin.info.owner", "[owner]", this.plugin.getPlayers().getName(this.owner), "[uuid]", this.owner.toString());
            user.sendMessage("commands.admin.info.deaths", "[number]", String.valueOf(this.plugin.getPlayers().getDeaths(this.world, this.owner)));
            String resets = String.valueOf(this.plugin.getPlayers().getResets(this.world, this.owner));
            String total = this.plugin.getIWM().getResetLimit(this.world) < 0 ? "Unlimited" : String.valueOf(this.plugin.getIWM().getResetLimit(this.world));
            user.sendMessage("commands.admin.info.resets-left", "[number]", resets, "[total]", total);
            this.showMembers(user);
        }
        int maxHomes = this.island.getMaxHomes() == null ? this.plugin.getIWM().getMaxHomes(this.island.getWorld()) : this.island.getMaxHomes().intValue();
        user.sendMessage("commands.admin.info.max-homes", "[number]", String.valueOf(maxHomes));
        Vector location = this.island.getProtectionCenter().toVector();
        user.sendMessage("commands.admin.info.island-center", "[xyz]", Util.xyz(location));
        user.sendMessage("commands.admin.info.protection-range", RANGE, String.valueOf(this.island.getProtectionRange()));
        user.sendMessage("commands.admin.info.protection-coords", XZ1, Util.xyz(new Vector(this.island.getMinProtectedX(), this.world.getMinHeight(), this.island.getMinProtectedZ())), "[xz2]", Util.xyz(new Vector(this.island.getMaxProtectedX() - 1, this.world.getMaxHeight(), this.island.getMaxProtectedZ() - 1)));
        if (this.island.isSpawn()) {
            user.sendMessage("commands.admin.info.is-spawn", new String[0]);
        }
        if (!this.island.getBanned().isEmpty()) {
            user.sendMessage("commands.admin.info.banned-players", new String[0]);
            this.island.getBanned().forEach(u -> user.sendMessage("commands.admin.info.banned-format", "[name]", this.plugin.getPlayers().getName((UUID)u)));
        }
        IslandEvent.builder().island(this.island).location(this.island.getCenter()).reason(IslandEvent.Reason.INFO).involvedPlayer(user.getUniqueId()).build();
        return true;
    }

    public void showMembers(User user) {
        user.sendMessage("commands.admin.info.team-members-title", new String[0]);
        this.island.getMembers().forEach((u, i) -> {
            if (this.owner.equals(u)) {
                user.sendMessage("commands.admin.info.team-owner-format", "[name]", this.plugin.getPlayers().getName((UUID)u), "[rank]", user.getTranslation(RanksManager.getInstance().getRank((int)i), new String[0]));
            } else if (i > 0) {
                user.sendMessage("commands.admin.info.team-member-format", "[name]", this.plugin.getPlayers().getName((UUID)u), "[rank]", user.getTranslation(RanksManager.getInstance().getRank((int)i), new String[0]));
            }
        });
    }
}

