/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.listeners.flags.settings;

import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidFinishEvent;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.potion.PotionEffectType;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.flags.FlagListener;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.bentobox.util.Util;

public class MobSpawnListener
extends FlagListener {
    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onMobSpawnEvent(CreatureSpawnEvent e) {
        this.onMobSpawn(e);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onRaidStartEvent(RaidTriggerEvent event) {
        if (!this.getIWM().inWorld(event.getWorld())) {
            return;
        }
        Optional<Island> island = this.getIslands().getIslandAt(event.getPlayer().getLocation());
        if (Boolean.TRUE.equals(island.map(i -> !i.isAllowed(Flags.MONSTER_NATURAL_SPAWN)).orElseGet(() -> !Flags.MONSTER_NATURAL_SPAWN.isSetForWorld(event.getWorld())))) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onRaidFinishEvent(RaidFinishEvent event) {
        if (!this.getIWM().inWorld(event.getWorld())) {
            return;
        }
        Optional<Island> island = this.getIslands().getIslandAt(event.getRaid().getLocation());
        if (Boolean.TRUE.equals(island.map(i -> !i.isAllowed(Flags.MONSTER_NATURAL_SPAWN)).orElseGet(() -> !Flags.MONSTER_NATURAL_SPAWN.isSetForWorld(event.getWorld())))) {
            event.getWinners().forEach(player -> {
                if (player.isOnline()) {
                    player.removePotionEffect(PotionEffectType.HERO_OF_THE_VILLAGE);
                }
            });
        }
    }

    void onMobSpawn(CreatureSpawnEvent e) {
        if (!this.getIWM().inWorld(e.getEntity().getLocation())) {
            return;
        }
        switch (e.getSpawnReason()) {
            case DEFAULT: 
            case DROWNED: 
            case JOCKEY: 
            case LIGHTNING: 
            case MOUNT: 
            case NATURAL: 
            case NETHER_PORTAL: 
            case OCELOT_BABY: 
            case PATROL: 
            case RAID: 
            case REINFORCEMENTS: 
            case SILVERFISH_BLOCK: 
            case TRAP: 
            case VILLAGE_DEFENSE: 
            case VILLAGE_INVASION: {
                boolean cancelNatural = this.shouldCancel((Entity)e.getEntity(), e.getLocation(), Flags.ANIMAL_NATURAL_SPAWN, Flags.MONSTER_NATURAL_SPAWN);
                e.setCancelled(cancelNatural);
                break;
            }
            case SPAWNER: 
            case TRIAL_SPAWNER: {
                boolean cancelSpawners = this.shouldCancel((Entity)e.getEntity(), e.getLocation(), Flags.ANIMAL_SPAWNERS_SPAWN, Flags.MONSTER_SPAWNERS_SPAWN);
                e.setCancelled(cancelSpawners);
                break;
            }
        }
    }

    private boolean shouldCancel(Entity entity, Location loc, Flag animalSpawnFlag, Flag monsterSpawnFlag) {
        Optional<Island> island = this.getIslands().getIslandAt(loc);
        if (Util.isHostileEntity(entity) && !(entity instanceof PufferFish)) {
            return island.map(i -> !i.isAllowed(monsterSpawnFlag)).orElseGet(() -> !monsterSpawnFlag.isSetForWorld(entity.getWorld()));
        }
        if (Util.isPassiveEntity(entity) || entity instanceof PufferFish) {
            return island.map(i -> !i.isAllowed(animalSpawnFlag)).orElseGet(() -> !animalSpawnFlag.isSetForWorld(entity.getWorld()));
        }
        return false;
    }
}

