/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.objects.adapters;

import com.google.common.base.Enums;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.database.objects.adapters.AdapterInterface;

public class LogEntryListAdapter
implements AdapterInterface<List<LogEntry>, List<Map<String, Object>>> {
    private static final String TIMESTAMP = "timestamp";
    private static final String TYPE = "type";
    private static final String DATA = "data";

    @Override
    public List<LogEntry> deserialize(Object object) {
        LinkedList<LogEntry> result = new LinkedList<LogEntry>();
        if (object == null) {
            return result;
        }
        List serialized = (List)object;
        for (Map entry : serialized) {
            long timestamp = (Long)entry.get(TIMESTAMP);
            LogEntry.LogType type = (LogEntry.LogType)((Object)Enums.getIfPresent(LogEntry.LogType.class, (String)((String)entry.get(TYPE))).or((Object)LogEntry.LogType.UNKNOWN));
            Map data = (Map)entry.get(DATA);
            result.add(new LogEntry.Builder(type).timestamp(timestamp).data(data).build());
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> serialize(Object object) {
        LinkedList<Map<String, Object>> result = new LinkedList<Map<String, Object>>();
        if (object == null) {
            return result;
        }
        List history = (List)object;
        history.forEach(logEntry -> {
            LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
            value.put(TIMESTAMP, logEntry.getTimestamp());
            value.put(TYPE, logEntry.getType().name());
            if (logEntry.getData() != null) {
                value.put(DATA, logEntry.getData());
            }
            result.add(value);
        });
        return result;
    }
}

