/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.objects;

import com.google.gson.annotations.Expose;
import java.util.Objects;
import java.util.UUID;
import world.bentobox.bentobox.database.objects.DataObject;
import world.bentobox.bentobox.database.objects.Table;

@Table(name="TeamInvites")
public class TeamInvite
implements DataObject {
    @Expose
    private Type type;
    @Expose
    private UUID inviter;
    @Expose
    private String islandID;
    @Expose
    private String uniqueId;

    public TeamInvite(Type type, UUID inviter, UUID invitee, String islandID) {
        this.type = type;
        this.uniqueId = invitee.toString();
        this.inviter = inviter;
        this.islandID = islandID;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public Type getType() {
        return this.type;
    }

    public UUID getInvitee() {
        return UUID.fromString(this.uniqueId);
    }

    public UUID getInviter() {
        return this.inviter;
    }

    public String getIslandID() {
        return this.islandID;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inviter, this.uniqueId, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TeamInvite)) {
            return false;
        }
        TeamInvite other = (TeamInvite)obj;
        return Objects.equals(this.inviter, other.inviter) && Objects.equals(this.uniqueId, other.getUniqueId()) && this.type == other.type;
    }

    public static enum Type {
        COOP,
        TEAM,
        TRUST;

    }
}

