/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json.adapters;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Arrays;

public final class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final BiMap<String, T> enumMap = HashBiMap.create();

    public EnumTypeAdapter(Class<T> enumClass) {
        for (Enum value : (Enum[])enumClass.getEnumConstants()) {
            String name = value.name();
            try {
                SerializedName annotation = enumClass.getField(name).getAnnotation(SerializedName.class);
                if (annotation != null) {
                    Arrays.stream(annotation.alternate()).forEach(s -> this.enumMap.put(s, (Object)value));
                    name = annotation.value();
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            this.enumMap.put((Object)name, (Object)value);
        }
    }

    public T read(JsonReader input) throws IOException {
        if (JsonToken.NULL.equals((Object)input.peek())) {
            input.nextNull();
            return null;
        }
        return (T)((Enum)this.enumMap.get((Object)input.nextString()));
    }

    public void write(JsonWriter output, T enumValue) throws IOException {
        output.value(enumValue != null ? (String)this.enumMap.inverse().get(enumValue) : null);
    }
}

