/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.database.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.json.adapters.BiomeTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.BukkitObjectTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.EnumTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.FlagTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.ItemStackTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.LocationTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.MaterialTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.PairTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.PotionEffectTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.ProfessionTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.VectorTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.VillagerTypeAdapter;
import world.bentobox.bentobox.database.json.adapters.WorldTypeAdapter;
import world.bentobox.bentobox.util.Pair;

public class BentoboxTypeAdapterFactory
implements TypeAdapterFactory {
    final BentoBox plugin;

    public BentoboxTypeAdapterFactory(BentoBox plugin) {
        this.plugin = plugin;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class rawType = type.getRawType();
        if (Location.class.isAssignableFrom(rawType)) {
            return new LocationTypeAdapter();
        }
        if (Material.class.isAssignableFrom(rawType)) {
            return new MaterialTypeAdapter();
        }
        if (Biome.class.isAssignableFrom(rawType)) {
            return new BiomeTypeAdapter();
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            return new EnumTypeAdapter(rawType);
        }
        if (ItemStack.class.isAssignableFrom(rawType)) {
            return new ItemStackTypeAdapter();
        }
        if (Flag.class.isAssignableFrom(rawType)) {
            return new FlagTypeAdapter(this.plugin);
        }
        if (PotionEffectType.class.isAssignableFrom(rawType)) {
            return new PotionEffectTypeAdapter();
        }
        if (World.class.isAssignableFrom(rawType)) {
            return new WorldTypeAdapter();
        }
        if (Vector.class.isAssignableFrom(rawType)) {
            return new VectorTypeAdapter();
        }
        if (Villager.Profession.class.isAssignableFrom(rawType)) {
            return new ProfessionTypeAdapter();
        }
        if (Villager.Type.class.isAssignableFrom(rawType)) {
            return new VillagerTypeAdapter();
        }
        if (Pair.class.isAssignableFrom(rawType)) {
            Type pairType = type.getType();
            ParameterizedType parameterizedType = (ParameterizedType)pairType;
            Type xType = parameterizedType.getActualTypeArguments()[0];
            Type zType = parameterizedType.getActualTypeArguments()[1];
            return new PairTypeAdapter(xType, zType);
        }
        if (ConfigurationSerializable.class.isAssignableFrom(rawType)) {
            return new BukkitObjectTypeAdapter((TypeAdapter<Map>)gson.getAdapter(Map.class));
        }
        return null;
    }
}

