/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.blueprints.conversation;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.conversation.DescriptionSuccessPrompt;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBundle;
import world.bentobox.bentobox.util.Util;

public class DescriptionPrompt
extends StringPrompt {
    private static final String DESCRIPTION = "description";
    private final GameModeAddon addon;
    private final BlueprintBundle bb;

    public DescriptionPrompt(GameModeAddon addon, BlueprintBundle bb) {
        this.addon = addon;
        this.bb = bb;
    }

    public @NonNull String getPromptText(ConversationContext context) {
        User user = User.getInstance((Player)context.getForWhom());
        if (context.getSessionData((Object)DESCRIPTION) != null) {
            StringBuilder sb = new StringBuilder();
            for (String line : (List)context.getSessionData((Object)DESCRIPTION)) {
                sb.append(user.getTranslation("commands.admin.blueprint.management.description.default-color", new String[0]));
                sb.append(line);
                sb.append(System.lineSeparator());
            }
            return sb.toString();
        }
        return user.getTranslation("commands.admin.blueprint.management.description.instructions", "[name]", this.bb.getDisplayName());
    }

    public Prompt acceptInput(ConversationContext context, String input) {
        User user = User.getInstance((Player)context.getForWhom());
        if (input.equals(user.getTranslation("commands.admin.blueprint.management.description.quit", new String[0]))) {
            return new DescriptionSuccessPrompt(this.addon, this.bb);
        }
        List<String> desc = new ArrayList<String>();
        if (context.getSessionData((Object)DESCRIPTION) != null) {
            desc = (List)context.getSessionData((Object)DESCRIPTION);
        }
        desc.add(Util.translateColorCodes(input));
        context.setSessionData((Object)DESCRIPTION, desc);
        return this;
    }
}

