/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.panels;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import world.bentobox.bentobox.api.panels.Panel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;

public class PanelItem {
    private ItemStack icon;
    private ClickHandler clickHandler;
    private List<String> description;
    private String name;
    private boolean glow;
    private ItemMeta meta;
    private final String playerHeadName;
    private boolean invisible;

    public static PanelItem empty() {
        return new PanelItemBuilder().build();
    }

    public PanelItem(PanelItemBuilder builtItem) {
        this.icon = builtItem.getIcon();
        this.icon.setAmount(builtItem.getAmount());
        this.playerHeadName = builtItem.getPlayerHeadName();
        this.meta = this.icon.getItemMeta();
        if (this.meta != null) {
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.icon.setItemMeta(this.meta);
        }
        this.clickHandler = builtItem.getClickHandler();
        this.setName(builtItem.getName());
        this.setDescription(builtItem.getDescription());
        this.setGlow(builtItem.isGlow());
        this.setInvisible(builtItem.isInvisible());
    }

    public ItemStack getItem() {
        return this.icon;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(List<String> description) {
        this.description = description;
        if (this.meta != null) {
            this.meta.setLore(description);
            this.icon.setItemMeta(this.meta);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.meta != null) {
            this.meta.setDisplayName(name);
            this.icon.setItemMeta(this.meta);
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
        if (this.meta != null && !this.inTest()) {
            if (invisible) {
                this.meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
                this.meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                this.meta.removeEnchant(Enchantment.VANISHING_CURSE);
                this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            this.icon.setItemMeta(this.meta);
        }
    }

    public Optional<ClickHandler> getClickHandler() {
        return Optional.ofNullable(this.clickHandler);
    }

    public void setClickHandler(ClickHandler clickHandler) {
        this.clickHandler = clickHandler;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
        if (this.inTest()) {
            return;
        }
        if (this.meta != null) {
            block6: {
                try {
                    this.meta.setEnchantmentGlintOverride(Boolean.valueOf(glow));
                }
                catch (NoSuchMethodError e) {
                    if (this.meta == null) break block6;
                    if (glow) {
                        this.meta.addEnchant(Enchantment.LURE, 0, true);
                    } else {
                        this.meta.removeEnchant(Enchantment.LURE);
                    }
                    this.icon.setItemMeta(this.meta);
                }
            }
            this.icon.setItemMeta(this.meta);
        }
    }

    private boolean inTest() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(e -> e.getClassName().endsWith("Test"));
    }

    public boolean isPlayerHead() {
        return this.playerHeadName != null && !this.playerHeadName.isEmpty();
    }

    public String getPlayerHeadName() {
        return this.playerHeadName;
    }

    public void setHead(ItemStack itemStack) {
        itemStack.setAmount(this.icon.getAmount());
        this.icon = itemStack;
        this.meta = this.icon.getItemMeta();
        if (this.meta != null) {
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
            this.meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            this.icon.setItemMeta(this.meta);
        }
        this.setName(this.name);
        this.setDescription(this.description);
        this.setGlow(this.glow);
    }

    public static interface ClickHandler {
        public boolean onClick(Panel var1, User var2, ClickType var3, int var4);
    }
}

