/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island.team;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.team.IslandTeamCommand;
import world.bentobox.bentobox.api.logs.LogEntry;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.database.objects.TeamInvite;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandTeamTrustCommand
extends CompositeCommand {
    IslandTeamCommand itc;
    private @Nullable UUID targetUUID;

    public IslandTeamTrustCommand(IslandTeamCommand parentCommand) {
        super(parentCommand, "trust", new String[0]);
        this.itc = parentCommand;
    }

    @Override
    public void setup() {
        this.setPermission("island.team.trust");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.team.trust.parameters");
        this.setDescription("commands.island.team.trust.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        this.targetUUID = this.getPlayers().getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (this.getSettings().getTrustCooldown() > 0 && this.checkCooldown(user, island.getUniqueId(), this.targetUUID.toString())) {
            return false;
        }
        if (user.getUniqueId().equals(this.targetUUID)) {
            user.sendMessage("commands.island.team.trust.trust-in-yourself", new String[0]);
            return false;
        }
        User target = User.getInstance(this.targetUUID);
        rank = this.getIslands().getIsland(this.getWorld(), user).getRank(target);
        if (rank >= 400) {
            user.sendMessage("commands.island.team.trust.player-already-trusted", new String[0]);
            return false;
        }
        if (this.itc.isInvited(this.targetUUID) && this.itc.getInviter(this.targetUUID).equals(user.getUniqueId()) && this.itc.getInvite(this.targetUUID).getType().equals((Object)TeamInvite.Type.TRUST)) {
            user.sendMessage("commands.island.team.invite.errors.you-have-already-invited", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        assert (this.targetUUID != null);
        User target = User.getInstance(this.targetUUID);
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            if (this.getPlugin().getSettings().isInviteConfirmation()) {
                this.itc.addInvite(TeamInvite.Type.TRUST, user.getUniqueId(), target.getUniqueId(), island);
                user.sendMessage("commands.island.team.invite.invitation-sent", "[name]", target.getName(), "[display_name]", target.getDisplayName());
                target.sendMessage("commands.island.team.trust.name-has-invited-you", "[name]", user.getName(), "[display_name]", user.getDisplayName());
                target.sendMessage("commands.island.team.invite.to-accept-or-reject", "[label]", this.getTopLabel());
            } else {
                if (island.getMemberSet(400, false).size() >= this.getIslands().getMaxMembers(island, 400)) {
                    user.sendMessage("commands.island.team.trust.is-full", new String[0]);
                    return false;
                }
                island.setRank(target, 400);
                user.sendMessage("commands.island.team.trust.success", "[name]", target.getName(), "[display_name]", target.getDisplayName());
                target.sendMessage("commands.island.team.trust.you-are-trusted", "[name]", user.getName(), "[display_name]", user.getDisplayName());
                island.log(new LogEntry.Builder(LogEntry.LogType.TRUSTED).data(this.targetUUID.toString(), "trusted").data(user.getUniqueId().toString(), "trusted by").build());
            }
            return true;
        }
        user.sendMessage("general.errors.general", new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.getLast() : "";
        if (lastArg.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Util.tabLimit(Util.getOnlinePlayerList(user), lastArg));
    }
}

