/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.conversations.NamePrompt;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandRenamehomeCommand
extends ConfirmableCommand {
    private @Nullable Island island;

    public IslandRenamehomeCommand(CompositeCommand islandCommand) {
        super(islandCommand, "renamehome", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.renamehome");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.renamehome.parameters");
        this.setDescription("commands.island.renamehome.description");
        this.setConfigurableRankCommand();
        this.setDefaultCommandRank(500);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        this.island = this.getIslands().getIsland(this.getWorld(), user);
        if (this.island == null) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        if (!this.getIslands().isHomeLocation(this.island, String.join((CharSequence)" ", args))) {
            user.sendMessage("commands.island.go.unknown-home", new String[0]);
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            this.island.getHomes().keySet().stream().filter(s -> !s.isEmpty()).forEach(s -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)s));
            this.showHelp(this, user);
            return false;
        }
        int rank = Objects.requireNonNull(this.island).getRank(user);
        if (rank < this.island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        assert (this.island != null);
        new ConversationFactory((Plugin)BentoBox.getInstance()).withModality(true).withLocalEcho(false).withTimeout(90).withFirstPrompt((Prompt)new NamePrompt(this.getPlugin(), this.island, user, String.join((CharSequence)" ", args))).buildConversation((Conversable)user.getPlayer()).begin();
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg = !args.isEmpty() ? args.getLast() : "";
        Island is = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (is != null) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(is.getHomes().keySet()), lastArg));
        }
        return Optional.empty();
    }
}

