/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.metadata.MetaDataValue;
import world.bentobox.bentobox.api.user.User;

public class AdminSwitchCommand
extends ConfirmableCommand {
    public static final String META_TAG = "AdminCommandSwitch";

    public AdminSwitchCommand(CompositeCommand parent) {
        super(parent, "switch", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.switch");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.admin.switch.parameters");
        this.setDescription("commands.admin.switch.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        boolean switchState = user.getMetaData(META_TAG).map(MetaDataValue::asBoolean).orElse(false);
        if (switchState) {
            user.putMetaData(META_TAG, new MetaDataValue(false));
            user.sendMessage("commands.admin.switch.adding", new String[0]);
            user.sendMessage("general.success", new String[0]);
        } else {
            user.putMetaData(META_TAG, new MetaDataValue(true));
            user.sendMessage("commands.admin.switch.removing", new String[0]);
            user.sendMessage("general.success", new String[0]);
        }
        return true;
    }
}

