/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FileLister {
    private final Plugin plugin;

    public FileLister(Plugin level) {
        this.plugin = level;
    }

    public List<String> list(String folderPath, boolean checkJar) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File localeDir = new File(this.plugin.getDataFolder(), folderPath);
        if (localeDir.exists()) {
            FilenameFilter ymlFilter = (dir, name) -> name.toLowerCase(Locale.ENGLISH).endsWith(".yml");
            return Arrays.asList(Objects.requireNonNull(localeDir.list(ymlFilter)));
        }
        if (checkJar) {
            return this.listJar(folderPath);
        }
        return result;
    }

    public List<String> listJar(String folderPath) throws IOException {
        File jarFile;
        ArrayList<String> result = new ArrayList<String>();
        try {
            Method method = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            method.setAccessible(true);
            jarFile = (File)method.invoke((Object)this.plugin, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        if (jarFile == null) {
            return result;
        }
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            if (!path.startsWith(folderPath) || !entry.getName().endsWith(".yml")) continue;
            result.add(entry.getName());
        }
        jar.close();
        return result;
    }
}

