/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.spawner.TrialSpawnerConfiguration;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintBlock;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintCreatureSpawner;
import world.bentobox.bentobox.blueprints.dataobjects.BlueprintEntity;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.hooks.FancyNpcsHook;
import world.bentobox.bentobox.hooks.ItemsAdderHook;
import world.bentobox.bentobox.hooks.MythicMobsHook;
import world.bentobox.bentobox.hooks.ZNPCsPlusHook;
import world.bentobox.bentobox.util.Util;

public class DefaultPasteUtil {
    private static final String MINECRAFT = "minecraft:";
    private static final Map<String, String> BLOCK_CONVERSION = Map.of("sign", "oak_sign", "wall_sign", "oak_wall_sign");
    private static final BentoBox plugin = BentoBox.getInstance();

    private DefaultPasteUtil() {
    }

    public static CompletableFuture<Void> setBlock(Island island, Location location, BlueprintBlock bpBlock) {
        return Util.getChunkAtAsync(location).thenRun(() -> {
            Block block = location.getBlock();
            BlockData bd = DefaultPasteUtil.createBlockData(bpBlock);
            block.setBlockData(bd, false);
            DefaultPasteUtil.setBlockState(island, block, bpBlock);
            if (bpBlock.getBiome() != null) {
                block.setBiome(bpBlock.getBiome());
            }
        });
    }

    public static BlockData createBlockData(BlueprintBlock block) {
        try {
            return Bukkit.createBlockData((String)block.getBlockData());
        }
        catch (Exception e) {
            return DefaultPasteUtil.convertBlockData(block);
        }
    }

    public static BlockData convertBlockData(BlueprintBlock block) {
        BlockData blockData = Bukkit.createBlockData((Material)Material.AIR);
        try {
            for (Map.Entry<String, String> en : BLOCK_CONVERSION.entrySet()) {
                if (!block.getBlockData().startsWith(MINECRAFT + en.getKey())) continue;
                blockData = Bukkit.createBlockData((String)block.getBlockData().replace(MINECRAFT + en.getKey(), MINECRAFT + en.getValue()));
                break;
            }
        }
        catch (IllegalArgumentException e) {
            plugin.logWarning("Blueprint references materials not supported on this server version.");
            plugin.logWarning("Load blueprint manually, check and save to fix for this server version.");
            plugin.logWarning("Failed block data: " + block.getBlockData());
        }
        return blockData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void setBlockState(Island island, Block block, BlueprintBlock bpBlock) {
        BlockState bs = block.getState();
        if (bs instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)bs;
            if (bpBlock.getInventory().isEmpty()) return;
            frame.setItem(bpBlock.getInventory().get(0));
            bs.update();
            return;
        }
        if (bs instanceof Sign) {
            Side[] sideArray = Side.values();
            int n = sideArray.length;
            int n2 = 0;
            while (n2 < n) {
                Side side = sideArray[n2];
                DefaultPasteUtil.writeSign(island, block, bpBlock, side);
                ++n2;
            }
            return;
        }
        if (bs instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)bs;
            Inventory ih = holder.getInventory();
            bpBlock.getInventory().forEach((arg_0, arg_1) -> ((Inventory)ih).setItem(arg_0, arg_1));
            return;
        }
        if (bs instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)bs;
            DefaultPasteUtil.setSpawner(spawner, bpBlock.getCreatureSpawner());
            return;
        }
        if (bs instanceof TrialSpawner) {
            TrialSpawner ts = (TrialSpawner)bs;
            TrialSpawnerConfiguration config = ts.getNormalConfiguration();
            ts.setOminous(bpBlock.getTrialSpawner().configTrialSpawner(config));
            if (bs.update(true, false)) return;
            BentoBox.getInstance().logError("Trial Spawner update failed!");
            return;
        }
        if (bs instanceof Banner) {
            Banner banner = (Banner)bs;
            if (bpBlock.getBannerPatterns() != null) {
                bpBlock.getBannerPatterns().removeIf(Objects::isNull);
                banner.setPatterns(bpBlock.getBannerPatterns());
                banner.update(true, false);
                return;
            }
        }
        if (bpBlock.getItemsAdderBlock() == null) return;
        if (bpBlock.getItemsAdderBlock().isEmpty()) return;
        BentoBox.getInstance().getHooks().getHook("ItemsAdder").ifPresent(h -> ItemsAdderHook.place(bpBlock.getItemsAdderBlock(), block.getLocation()));
    }

    public static void setSpawner(CreatureSpawner spawner, BlueprintCreatureSpawner s) {
        spawner.setSpawnedType(s.getSpawnedType());
        spawner.setMaxNearbyEntities(s.getMaxNearbyEntities());
        spawner.setMaxSpawnDelay(s.getMaxSpawnDelay());
        spawner.setMinSpawnDelay(s.getMinSpawnDelay());
        spawner.setDelay(s.getDelay());
        spawner.setRequiredPlayerRange(s.getRequiredPlayerRange());
        spawner.setSpawnRange(s.getSpawnRange());
        spawner.update(true, false);
    }

    public static CompletableFuture<Void> setEntity(Island island, Location location, List<BlueprintEntity> list) {
        World world = location.getWorld();
        assert (world != null);
        return Util.getChunkAtAsync(location).thenRun(() -> list.forEach(k -> DefaultPasteUtil.spawnBlueprintEntity(k, location, island)));
    }

    static boolean spawnBlueprintEntity(BlueprintEntity k, Location location, Island island) {
        k.setDisplay(location);
        if (k.getNpc() != null && plugin.getHooks().getHook("FancyNpcs").filter(mmh -> mmh instanceof FancyNpcsHook).map(mmh -> {
            try {
                return ((FancyNpcsHook)mmh).spawnNpc(k.getNpc(), location);
            }
            catch (InvalidConfigurationException e) {
                plugin.logError("FancyNpc loading failed in blueprint.");
                return false;
            }
        }).orElse(false).booleanValue()) {
            return false;
        }
        if (k.getNpc() != null && plugin.getHooks().getHook("ZNPCsPlus").filter(mmh -> mmh instanceof ZNPCsPlusHook).map(znpch -> {
            try {
                return ((ZNPCsPlusHook)znpch).spawnNpc(k.getNpc(), location);
            }
            catch (InvalidConfigurationException e) {
                plugin.logError("ZNPCsPlus loading failed in blueprint.");
                return false;
            }
        }).orElse(false).booleanValue()) {
            return false;
        }
        if (k.getMythicMobsRecord() != null && plugin.getHooks().getHook("MythicMobs").filter(mmh -> mmh instanceof MythicMobsHook).map(mmh -> ((MythicMobsHook)mmh).spawnMythicMob(k.getMythicMobsRecord(), location)).orElse(false).booleanValue()) {
            return false;
        }
        if (k.getType() == null) {
            return false;
        }
        Entity e = location.getWorld().spawnEntity(location, k.getType());
        if (k.getCustomName() != null) {
            Optional<Player> owner;
            String customName = k.getCustomName();
            if (island != null && (owner = Optional.ofNullable(island.getOwner()).map(User::getInstance).map(User::getPlayer)).isPresent()) {
                customName = customName.replace("[name]", owner.get().getName());
                customName = plugin.getPlaceholdersManager().replacePlaceholders(owner.get(), customName);
            }
            e.customName((Component)Component.text((String)customName));
        }
        k.configureEntity(e);
        return true;
    }

    public static void writeSign(Island island, Block block, BlueprintBlock bpSign, Side side) {
        BlockFace bf;
        List<String> lines = bpSign.getSignLines(side);
        boolean glow = bpSign.isGlowingText(side);
        BlockData bd = block.getBlockData();
        if (bd instanceof WallSign) {
            WallSign ws = (WallSign)bd;
            v0 = ws.getFacing();
        } else {
            v0 = bf = ((org.bukkit.block.data.type.Sign)bd).getRotation();
        }
        if (side == Side.FRONT && island != null && !lines.isEmpty() && lines.getFirst().equalsIgnoreCase("[spawn_here]")) {
            Waterlogged wl;
            if (bd instanceof Waterlogged && (wl = (Waterlogged)bd).isWaterlogged()) {
                block.setType(Material.WATER);
            } else {
                block.setType(Material.AIR);
            }
            Location spawnPoint = new Location(block.getWorld(), (double)block.getX() + 0.5, (double)block.getY(), (double)block.getZ() + 0.5, Util.blockFaceToFloat(bf.getOppositeFace()), 30.0f);
            island.setSpawnPoint(block.getWorld().getEnvironment(), spawnPoint);
            return;
        }
        String name = "";
        if (island != null) {
            name = plugin.getPlayers().getName(island.getOwner());
        }
        Sign s = (Sign)block.getState();
        SignSide signSide = s.getSide(side);
        if (island != null && !lines.isEmpty() && lines.getFirst().equalsIgnoreCase("[start]")) {
            String addonName = plugin.getIWM().getAddon(island.getWorld()).map(addon -> addon.getDescription().getName().toLowerCase(Locale.ENGLISH)).orElse("");
            Optional<User> user = Optional.ofNullable(island.getOwner()).map(User::getInstance);
            if (user.isPresent()) {
                for (int i = 0; i < 4; ++i) {
                    signSide.setLine(i, Util.translateColorCodes(plugin.getLocalesManager().getOrDefault(user.get(), addonName + ".sign.line" + i, "").replace("[name]", name)));
                }
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                signSide.setLine(i, lines.get(i));
            }
        }
        signSide.setGlowingText(glow);
        s.update();
    }
}

