/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.commands;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.versions.ServerCompatibility;

public class BentoBoxVersionCommand
extends CompositeCommand {
    public BentoBoxVersionCommand(CompositeCommand parent) {
        super(parent, "version", "v", "ver", "versions", "addons");
    }

    @Override
    public void setup() {
        this.setPermission("bentobox.version");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        ServerCompatibility.ServerSoftware serverSoftware = ServerCompatibility.getInstance().getServerSoftware();
        ServerCompatibility.ServerVersion serverVersion = ServerCompatibility.getInstance().getServerVersion();
        user.sendMessage("commands.bentobox.version.server", new String[]{"[name]", serverSoftware.equals((Object)ServerCompatibility.ServerSoftware.UNKNOWN) ? user.getTranslation("general.invalid", new String[0]) + " (" + serverSoftware.getName() + ")" : serverSoftware.toString(), "[version]", serverVersion != null ? serverVersion.toString() : user.getTranslation("general.invalid", new String[0])});
        user.sendRawMessage("(" + Bukkit.getVersion() + ")");
        user.sendMessage("commands.bentobox.version.plugin-version", "[version]", this.getPlugin().getDescription().getVersion());
        user.sendMessage("commands.bentobox.version.database", "[database]", this.getSettings().getDatabaseType().toString());
        user.sendMessage("commands.bentobox.version.loaded-game-worlds", new String[0]);
        this.getIWM().getOverWorldNames().entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> {
            Object worlds = user.getTranslation("general.worlds.overworld", new String[0]);
            Optional<GameModeAddon> addonOptional = this.getIWM().getAddon(Bukkit.getWorld((String)((String)e.getKey())));
            if (addonOptional.isPresent()) {
                GameModeAddon addon = addonOptional.get();
                if (addon.getNetherWorld() != null && this.getIWM().isNetherGenerate(addon.getOverWorld())) {
                    worlds = (String)worlds + ", " + user.getTranslation("general.worlds.nether", new String[0]);
                    if (!this.getIWM().isNetherIslands(addon.getOverWorld())) {
                        worlds = (String)worlds + "*";
                    }
                }
                if (addon.getEndWorld() != null && this.getIWM().isEndGenerate(addon.getOverWorld())) {
                    worlds = (String)worlds + ", " + user.getTranslation("general.worlds.the-end", new String[0]);
                    if (!this.getIWM().isEndIslands(addon.getOverWorld())) {
                        worlds = (String)worlds + "*";
                    }
                }
            }
            user.sendMessage(user.getTranslation("commands.bentobox.version.game-world", new String[]{"[name]", (String)e.getKey(), "[addon]", (String)e.getValue(), "[worlds]", worlds}), new String[0]);
        });
        user.sendMessage("commands.bentobox.version.loaded-addons", new String[0]);
        this.getPlugin().getAddonsManager().getAddons().stream().sorted(Comparator.comparing(o -> o.getDescription().getName().toLowerCase(Locale.ENGLISH))).forEach(a -> user.sendMessage("commands.bentobox.version.addon-syntax", "[name]", a.getDescription().getName(), "[version]", a.getDescription().getVersion(), "[state]", a.getState().toString()));
        return true;
    }
}

