/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.commands;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.Database;
import world.bentobox.bentobox.database.objects.DataObject;

public class BentoBoxMigrateCommand
extends ConfirmableCommand {
    private static final String MIGRATED = "commands.bentobox.migrate.migrated";
    private Queue<Class<? extends DataObject>> classQueue;
    private BukkitTask task;

    public BentoBoxMigrateCommand(CompositeCommand parent) {
        super(parent, "migrate", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("bentobox.admin.migrate");
        this.setDescription("commands.bentobox.migrate.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        this.askConfirmation(user, () -> {
            user.sendMessage("commands.bentobox.migrate.addons", new String[0]);
            Set<Class<? extends DataObject>> classSet = this.getPlugin().getAddonsManager().getDataObjects();
            classSet.addAll(Database.getDataobjects());
            this.classQueue = new LinkedList<Class<? extends DataObject>>(classSet);
            this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.getPlugin(), () -> {
                Class<? extends DataObject> t = this.classQueue.poll();
                if (t != null) {
                    user.sendMessage("commands.bentobox.migrate.class", "[description]", BentoBox.getInstance().getSettings().getDatabasePrefix() + t.getCanonicalName());
                    new Database<DataObject>(this.getPlugin(), t).loadObjects();
                    user.sendMessage(MIGRATED, new String[0]);
                } else {
                    user.sendMessage("commands.bentobox.migrate.completed", new String[0]);
                    this.task.cancel();
                }
            }, 0L, 20L);
        });
        return true;
    }
}

