/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.flags;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.clicklisteners.CycleClick;
import world.bentobox.bentobox.api.flags.clicklisteners.IslandToggleClick;
import world.bentobox.bentobox.api.flags.clicklisteners.WorldToggleClick;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.ItemParser;

public class Flag
implements Comparable<Flag> {
    private static final String PROTECTION_FLAGS = "protection.flags.";
    private final String id;
    private final Material icon;
    private final Listener listener;
    private final Type type;
    private boolean setting;
    private final int defaultRank;
    private final PanelItem.ClickHandler clickHandler;
    private final boolean subPanel;
    private Set<GameModeAddon> gameModes = new HashSet<GameModeAddon>();
    private final Addon addon;
    private final int cooldown;
    private final Mode mode;
    private final Set<Flag> subflags;
    private final HideWhen hideWhen;
    private boolean isSubFlag;
    private Flag parentFlag;

    private Flag(Builder builder) {
        this.id = builder.id;
        this.icon = builder.icon;
        this.listener = builder.listener;
        this.type = builder.type;
        this.setting = builder.defaultSetting;
        this.defaultRank = builder.defaultRank;
        this.clickHandler = builder.clickHandler;
        this.subPanel = builder.usePanel;
        if (builder.gameModeAddon != null) {
            this.gameModes.add(builder.gameModeAddon);
        }
        this.cooldown = builder.cooldown;
        this.addon = builder.addon;
        this.mode = builder.mode;
        this.subflags = builder.subflags;
        this.hideWhen = builder.hideWhen;
        this.isSubFlag = false;
        this.parentFlag = null;
    }

    public String getID() {
        return this.id;
    }

    public Material getIcon() {
        return this.icon;
    }

    public Optional<Listener> getListener() {
        return Optional.ofNullable(this.listener);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isSetForWorld(World world) {
        if (!BentoBox.getInstance().getIWM().inWorld(world)) {
            return false;
        }
        WorldSettings ws = BentoBox.getInstance().getIWM().getWorldSettings(world);
        if (this.type.equals((Object)Type.WORLD_SETTING) || this.type.equals((Object)Type.PROTECTION)) {
            if (!ws.getWorldFlags().containsKey(this.getID())) {
                ws.getWorldFlags().put(this.getID(), this.setting);
                BentoBox.getInstance().getIWM().getAddon(world).ifPresent(GameModeAddon::saveWorldSettings);
            }
            return ws.getWorldFlags().get(this.getID());
        }
        return this.setting;
    }

    public void setSetting(World world, boolean setting) {
        if (this.getType().equals((Object)Type.WORLD_SETTING) || this.type.equals((Object)Type.PROTECTION)) {
            BentoBox.getInstance().getIWM().getWorldSettings(world).getWorldFlags().put(this.getID(), setting);
            if (this.hasSubflags()) {
                this.subflags.stream().filter(subflag -> subflag.getType().equals((Object)Type.WORLD_SETTING) || subflag.getType().equals((Object)Type.PROTECTION)).forEach(subflag -> BentoBox.getInstance().getIWM().getWorldSettings(world).getWorldFlags().put(subflag.getID(), setting));
            }
            BentoBox.getInstance().getIWM().getAddon(world).ifPresent(GameModeAddon::saveWorldSettings);
        }
    }

    public void setDefaultSetting(boolean defaultSetting) {
        this.setting = defaultSetting;
    }

    public void setDefaultSetting(World world, boolean defaultSetting) {
        if (!BentoBox.getInstance().getIWM().inWorld(world)) {
            BentoBox.getInstance().logError("Attempt to set default world setting for unregistered world. Register flags in onEnable.");
            return;
        }
        BentoBox.getInstance().getIWM().getWorldSettings(world).getWorldFlags().put(this.getID(), defaultSetting);
        BentoBox.getInstance().getIWM().getAddon(world).ifPresent(GameModeAddon::saveWorldSettings);
    }

    public Type getType() {
        return this.type;
    }

    public int getDefaultRank() {
        return this.defaultRank;
    }

    public boolean hasSubPanel() {
        return this.subPanel;
    }

    public Addon getAddon() {
        return this.addon;
    }

    public HideWhen getHideWhen() {
        return this.hideWhen;
    }

    public boolean isSubFlag() {
        return this.isSubFlag;
    }

    public Flag getParentFlag() {
        return this.parentFlag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Flag)) {
            return false;
        }
        Flag other = (Flag)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public String getNameReference() {
        return PROTECTION_FLAGS + this.id + ".name";
    }

    public String getIconReference() {
        return PROTECTION_FLAGS + this.id + ".icon";
    }

    public String getDescriptionReference() {
        return PROTECTION_FLAGS + this.id + ".description";
    }

    public String getHintReference() {
        return PROTECTION_FLAGS + this.id + ".hint";
    }

    public Set<GameModeAddon> getGameModes() {
        return this.gameModes;
    }

    public void setGameModes(Set<GameModeAddon> gameModeAddon) {
        this.gameModes = gameModeAddon;
    }

    public void addGameModeAddon(GameModeAddon gameModeAddon) {
        this.gameModes.add(gameModeAddon);
    }

    public boolean removeGameModeAddon(GameModeAddon gameModeAddon) {
        return this.gameModes.remove(gameModeAddon);
    }

    public @Nullable PanelItem toPanelItem(BentoBox plugin, User user, World world, @Nullable Island island, boolean invisible) {
        if (!user.isOp() && invisible) {
            return null;
        }
        PanelItemBuilder pib = new PanelItemBuilder().icon(ItemParser.parse(user.getTranslationOrNothing(this.getIconReference(), new String[0]), new ItemStack(this.icon))).name(user.getTranslation("protection.panel.flag-item.name-layout", "[name]", user.getTranslation(this.getNameReference(), new String[0]))).clickHandler(this.clickHandler).invisible(invisible);
        if (this.hasSubPanel()) {
            pib.description(user.getTranslation("protection.panel.flag-item.menu-layout", "[description]", user.getTranslation(this.getDescriptionReference(), new String[0])));
            return pib.build();
        }
        return switch (this.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.createProtectionFlag(plugin, user, island, pib).build();
            case 1 -> this.createSettingFlag(user, island, pib).build();
            case 2 -> this.createWorldSettingFlag(user, world, pib).build();
        };
    }

    private PanelItemBuilder createWorldSettingFlag(User user, World world, PanelItemBuilder pib) {
        String worldSetting = this.isSetForWorld(world) ? user.getTranslation("protection.panel.flag-item.setting-active", new String[0]) : user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]);
        pib.description(user.getTranslation("protection.panel.flag-item.setting-layout", "[description]", user.getTranslation(this.getDescriptionReference(), new String[0]), "[setting]", worldSetting));
        return pib;
    }

    private PanelItemBuilder createSettingFlag(User user, Island island, PanelItemBuilder pib) {
        if (island != null) {
            String islandSetting = island.isAllowed(this) ? user.getTranslation("protection.panel.flag-item.setting-active", new String[0]) : user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]);
            pib.description(user.getTranslation("protection.panel.flag-item.setting-layout", "[description]", user.getTranslation(this.getDescriptionReference(), new String[0]), "[setting]", islandSetting));
            if (this.cooldown > 0 && island.isCooldown(this)) {
                pib.description(user.getTranslation("protection.panel.flag-item.setting-cooldown", new String[0]));
            }
        }
        return pib;
    }

    private PanelItemBuilder createProtectionFlag(BentoBox plugin, User user, Island island, PanelItemBuilder pib) {
        if (island != null) {
            int y = island.getFlag(this);
            pib.description(user.getTranslation("protection.panel.flag-item.description-layout", "[description]", user.getTranslation(this.getDescriptionReference(), new String[0])));
            RanksManager.getInstance().getRanks().forEach((reference, score) -> {
                if (score > -1 && score < y) {
                    pib.description(user.getTranslation("protection.panel.flag-item.blocked-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
                } else if (score <= 1000 && score > y) {
                    pib.description(user.getTranslation("protection.panel.flag-item.allowed-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
                } else if (score == y) {
                    pib.description(user.getTranslation("protection.panel.flag-item.minimal-rank", new String[0]) + user.getTranslation((String)reference, new String[0]));
                }
            });
        }
        return pib;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean hasSubflags() {
        return !this.subflags.isEmpty();
    }

    public Set<Flag> getSubflags() {
        return this.subflags;
    }

    public boolean setTranslatedName(Locale locale, String name) {
        return BentoBox.getInstance().getLocalesManager().setTranslation(locale, this.getNameReference(), name);
    }

    public boolean setTranslatedDescription(Locale locale, String description) {
        return BentoBox.getInstance().getLocalesManager().setTranslation(locale, this.getDescriptionReference(), description);
    }

    public String toString() {
        return "Flag [id=" + this.id + "]";
    }

    @Override
    public int compareTo(Flag o) {
        return this.getID().compareTo(o.getID());
    }

    public static class Builder {
        private final String id;
        private final Material icon;
        private Listener listener;
        private Type type = Type.PROTECTION;
        private boolean defaultSetting = false;
        private int defaultRank = 500;
        private PanelItem.ClickHandler clickHandler;
        private boolean usePanel = false;
        private GameModeAddon gameModeAddon;
        private Addon addon;
        private int cooldown;
        private Mode mode = Mode.EXPERT;
        private final Set<Flag> subflags;
        private HideWhen hideWhen = HideWhen.NEVER;

        public Builder(String id, Material icon) {
            this.id = id;
            this.icon = icon;
            this.subflags = new HashSet<Flag>();
        }

        public Builder listener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder clickHandler(PanelItem.ClickHandler clickHandler) {
            this.clickHandler = clickHandler;
            return this;
        }

        public Builder defaultSetting(boolean defaultSetting) {
            this.defaultSetting = defaultSetting;
            return this;
        }

        public Builder defaultRank(int defaultRank) {
            this.defaultRank = defaultRank;
            return this;
        }

        public Builder usePanel(boolean usePanel) {
            this.usePanel = usePanel;
            return this;
        }

        public Builder setGameMode(GameModeAddon gameModeAddon) {
            this.gameModeAddon = gameModeAddon;
            return this;
        }

        public Builder addon(Addon addon) {
            this.addon = addon;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder mode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder subflags(Flag ... flags) {
            this.subflags.addAll(Arrays.asList(flags));
            for (Flag flag : flags) {
                flag.isSubFlag = true;
            }
            return this;
        }

        public Builder hideWhen(HideWhen hideWhen) {
            this.hideWhen = hideWhen;
            return this;
        }

        public Flag build() {
            if (this.clickHandler == null) {
                this.clickHandler = switch (this.type.ordinal()) {
                    case 1 -> new IslandToggleClick(this.id);
                    case 2 -> new WorldToggleClick(this.id);
                    default -> new CycleClick(this.id);
                };
            }
            Flag flag = new Flag(this);
            this.subflags.forEach(subflag -> {
                subflag.parentFlag = flag;
            });
            return flag;
        }
    }

    public static enum Type {
        PROTECTION(Material.SHIELD),
        SETTING(Material.COMPARATOR),
        WORLD_SETTING(Material.GRASS_BLOCK);

        private final @NonNull Material icon;

        private Type(Material icon) {
            this.icon = icon;
        }

        public @NonNull Material getIcon() {
            return this.icon;
        }
    }

    public static enum Mode {
        BASIC,
        ADVANCED,
        EXPERT,
        TOP_ROW;


        public Mode getNext() {
            return switch (this.ordinal()) {
                case 1 -> EXPERT;
                case 0 -> ADVANCED;
                default -> BASIC;
            };
        }

        public boolean isGreaterThan(Mode rank) {
            return switch (this.ordinal()) {
                case 2 -> {
                    if (rank.equals((Object)BASIC) || rank.equals((Object)ADVANCED)) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> rank.equals((Object)BASIC);
                default -> false;
            };
        }
    }

    public static enum HideWhen {
        NEVER,
        SETTING_TRUE,
        SETTING_FALSE;

    }
}

