/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandUnbanCommand
extends CompositeCommand {
    private @Nullable UUID targetUUID;

    public IslandUnbanCommand(CompositeCommand islandCommand) {
        super(islandCommand, "unban", "pardon");
    }

    @Override
    public void setup() {
        this.setPermission("island.ban");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.unban.parameters");
        this.setDescription("commands.island.unban.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID playerUUID = user.getUniqueId();
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        this.targetUUID = this.getPlayers().getUUID(args.getFirst());
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.getFirst());
            return false;
        }
        if (playerUUID.equals(this.targetUUID)) {
            user.sendMessage("commands.island.unban.cannot-unban-yourself", new String[0]);
            return false;
        }
        if (!island.isBanned(this.targetUUID)) {
            user.sendMessage("commands.island.unban.player-not-banned", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        assert (this.targetUUID != null);
        User target = User.getInstance(this.targetUUID);
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        IslandBaseEvent unbanEvent = IslandEvent.builder().island(island).involvedPlayer(target.getUniqueId()).admin(false).reason(IslandEvent.Reason.UNBAN).build();
        if (unbanEvent.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(unbanEvent.isCancelled()).booleanValue()) {
            return false;
        }
        assert (island != null);
        if (island.unban(user.getUniqueId(), target.getUniqueId())) {
            user.sendMessage("commands.island.unban.player-unbanned", "[name]", target.getName(), "[display_name]", target.getDisplayName());
            target.sendMessage("commands.island.unban.you-are-unbanned", "[name]", user.getName(), "[display_name]", user.getDisplayName());
            if (this.getSettings().getBanCooldown() > 0 && this.getParent() != null) {
                this.getParent().getSubCommand("ban").ifPresent(subCommand -> subCommand.setCooldown(island.getUniqueId(), target.getUniqueId().toString(), this.getSettings().getBanCooldown() * 60));
            }
            return true;
        }
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            List<String> options = island.getBanned().stream().map(this.getPlayers()::getName).toList();
            String lastArg = !args.isEmpty() ? args.getLast() : "";
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

