/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.commands.admin.range.AbstractAdminRangeCommand;
import world.bentobox.bentobox.api.commands.admin.range.AdminRangeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminRangeRemoveCommand
extends AbstractAdminRangeCommand {
    public AdminRangeRemoveCommand(AdminRangeCommand parent) {
        super(parent, "remove");
    }

    @Override
    public void setup() {
        this.setPermission("admin.range.remove");
        this.setDescription("commands.admin.range.remove.description");
        this.setParametersHelp("commands.admin.range.remove.parameters");
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
            return false;
        }
        int newRange = this.targetIsland.getProtectionRange() - Integer.parseInt(args.get(1));
        if (newRange <= 1) {
            user.sendMessage("commands.admin.range.invalid-value.too-low", "[number]", String.valueOf(this.targetIsland.getRange()));
            return false;
        }
        if (newRange == this.targetIsland.getProtectionRange()) {
            user.sendMessage("commands.admin.range.invalid-value.same-as-before", "[number]", args.get(1));
            return false;
        }
        int oldRange = this.targetIsland.getProtectionRange();
        this.targetIsland.setProtectionRange(newRange);
        IslandEvent.builder().island(this.targetIsland).location(this.targetIsland.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(this.targetUUID).admin(true).protectionRange(newRange, oldRange).build();
        user.sendMessage("commands.admin.range.remove.success", "[name]", args.getFirst(), "[number]", args.get(1), "[total]", String.valueOf(newRange));
        return true;
    }
}

