/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;

public abstract class ConfirmableCommand
extends CompositeCommand {
    private static final Map<User, Confirmer> toBeConfirmed = new HashMap<User, Confirmer>();

    protected ConfirmableCommand(Addon addon, String label, String ... aliases) {
        super(addon, label, aliases);
    }

    protected ConfirmableCommand(Addon addon, CompositeCommand parent, String label, String ... aliases) {
        super(addon, parent, label, aliases);
    }

    protected ConfirmableCommand(CompositeCommand parent, String label, String ... aliases) {
        super(parent, label, aliases);
    }

    public void askConfirmation(User user, String message, Runnable confirmed) {
        if (toBeConfirmed.containsKey(user)) {
            if (toBeConfirmed.get(user).topLabel().equals(this.getTopLabel()) && toBeConfirmed.get(user).label().equalsIgnoreCase(this.getLabel())) {
                toBeConfirmed.get(user).task().cancel();
                Bukkit.getScheduler().runTask((Plugin)this.getPlugin(), toBeConfirmed.get(user).runnable());
                toBeConfirmed.remove(user);
                return;
            }
            user.sendMessage("commands.confirmation.previous-request-cancelled", new String[0]);
        }
        if (!message.trim().isEmpty()) {
            user.sendRawMessage(message);
        }
        user.sendMessage("commands.confirmation.confirm", "[seconds]", String.valueOf(this.getSettings().getConfirmationTime()));
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.getPlugin(), () -> {
            user.sendMessage("commands.confirmation.request-cancelled", new String[0]);
            toBeConfirmed.remove(user);
        }, (long)this.getPlugin().getSettings().getConfirmationTime() * 20L);
        toBeConfirmed.put(user, new Confirmer(this.getTopLabel(), this.getLabel(), confirmed, task));
    }

    public void askConfirmation(User user, Runnable confirmed) {
        this.askConfirmation(user, "", confirmed);
    }

    private record Confirmer(String topLabel, String label, Runnable runnable, BukkitTask task) {
    }
}

