/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util.heads;

import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class HeadCache {
    private final String userName;
    private final UUID userId;
    public final PlayerProfile playerProfile;
    private final long timestamp;

    public HeadCache(String userName, UUID userId, PlayerProfile playerProfile) {
        this(userName, userId, playerProfile, System.currentTimeMillis());
    }

    public HeadCache(String userName, UUID userId, PlayerProfile playerProfile, long timestamp) {
        this.userName = userName;
        this.playerProfile = playerProfile;
        this.userId = userId;
        this.timestamp = timestamp;
    }

    public ItemStack getPlayerHead() {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        if (meta != null && this.playerProfile != null) {
            try {
                meta.setOwnerProfile(this.playerProfile);
                item.setItemMeta((ItemMeta)meta);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return item;
    }

    public String getUserName() {
        return this.userName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public UUID getUserId() {
        return this.userId;
    }
}

