/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.util;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.util.Vector;
import org.eclipse.jdt.annotation.NonNull;

public class MyBiomeGrid
implements ChunkGenerator.BiomeGrid {
    Map<Vector, Biome> map = new HashMap<Vector, Biome>();
    private final Biome defaultBiome;

    public MyBiomeGrid(World.Environment environment) {
        switch (environment) {
            case NETHER: {
                this.defaultBiome = Biome.NETHER_WASTES;
                break;
            }
            case THE_END: {
                this.defaultBiome = Biome.THE_END;
                break;
            }
            default: {
                this.defaultBiome = Biome.PLAINS;
            }
        }
    }

    public @NonNull Biome getBiome(int x, int z) {
        return this.map.getOrDefault(new Vector(x, 0, z), this.defaultBiome);
    }

    public void setBiome(int x, int z, @NonNull Biome bio) {
        this.map.put(new Vector(x, 0, z), bio);
    }

    public @NonNull Biome getBiome(int x, int y, int z) {
        return this.map.getOrDefault(new Vector(x, y, z), this.defaultBiome);
    }

    public void setBiome(int x, int y, int z, @NonNull Biome bio) {
        this.map.put(new Vector(x, y, z), bio);
    }
}

