/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.customizable;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Material;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.localization.BentoBoxLocale;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.builders.PanelItemBuilder;
import world.bentobox.bentobox.api.panels.builders.TemplatedPanelBuilder;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.panels.customizable.AbstractPanel;
import world.bentobox.bentobox.util.Util;

public class LanguagePanel
extends AbstractPanel {
    private final List<Locale> elementList;

    public LanguagePanel(CompositeCommand command, User user) {
        super(command, user);
        this.elementList = this.plugin.getLocalesManager().getAvailableLocales(true);
    }

    public static void openPanel(@NonNull CompositeCommand command, @NonNull User user) {
        new LanguagePanel(command, user).build();
    }

    @Override
    protected void build() {
        if (this.elementList.isEmpty()) {
            this.plugin.logError("There are no available locales for selection!");
            this.user.sendMessage("no-locales", "[gamemode]", this.plugin.getDescription().getName());
            return;
        }
        TemplatedPanelBuilder panelBuilder = new TemplatedPanelBuilder();
        if (this.doesCustomPanelExists((GameModeAddon)this.command.getAddon(), "language_panel")) {
            panelBuilder.template("language_panel", new File(((Addon)this.command.getAddon()).getDataFolder(), "panels"));
        } else {
            panelBuilder.template("language_panel", new File(this.plugin.getDataFolder(), "panels"));
        }
        panelBuilder.user(this.user);
        panelBuilder.world(this.user.getWorld());
        panelBuilder.registerTypeBuilder("LOCALE", this::createLocaleButton);
        panelBuilder.registerTypeBuilder("NEXT", this::createNextButton);
        panelBuilder.registerTypeBuilder("PREVIOUS", this::createPreviousButton);
        panelBuilder.build();
    }

    @Override
    protected @Nullable PanelItem createNextButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        int size = this.elementList.size();
        if (size <= slot.amountMap().getOrDefault("LOCALE", 1) || 1.0 * (double)size / (double)slot.amountMap().getOrDefault("LOCALE", 1).intValue() <= (double)(this.pageIndex + 1)) {
            return null;
        }
        int nextPageIndex = this.pageIndex + 2;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(nextPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(template.description(), "[number]", String.valueOf(nextPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "NEXT".equalsIgnoreCase(action.actionType())) {
                    ++this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    @Override
    protected @Nullable PanelItem createPreviousButton(@NonNull ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.pageIndex == 0) {
            return null;
        }
        int previousPageIndex = this.pageIndex;
        PanelItemBuilder builder = new PanelItemBuilder();
        if (template.icon() != null) {
            ItemStack clone = template.icon().clone();
            if (((Boolean)template.dataMap().getOrDefault("indexing", false)).booleanValue()) {
                clone.setAmount(previousPageIndex);
            }
            builder.icon(clone);
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), new String[0]));
        }
        if (template.description() != null) {
            builder.description(this.user.getTranslation(this.command.getWorld(), template.description(), "[number]", String.valueOf(previousPageIndex)));
        }
        builder.clickHandler((panel, user, clickType, i) -> {
            template.actions().forEach(action -> {
                if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && "PREVIOUS".equalsIgnoreCase(action.actionType())) {
                    --this.pageIndex;
                    this.build();
                }
            });
            return true;
        });
        List tooltips = template.actions().stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(template.actions().size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }

    private @Nullable PanelItem createLocaleButton(ItemTemplateRecord template, TemplatedPanel.ItemSlot slot) {
        if (this.elementList.isEmpty()) {
            return null;
        }
        int index = this.pageIndex * slot.amountMap().getOrDefault("LOCALE", 1) + slot.slot();
        Locale locale = index >= this.elementList.size() ? null : this.elementList.get(index);
        if (template.dataMap().containsKey("lang_id")) {
            locale = this.elementList.stream().filter(localeID -> localeID.toLanguageTag().equals(template.dataMap().get("lang_id"))).findFirst().orElse(locale);
        }
        return this.createLocaleButton(template, locale);
    }

    private PanelItem createLocaleButton(ItemTemplateRecord template, Locale locale) {
        if (locale == null) {
            return null;
        }
        String reference = "panels.language.buttons.language.";
        PanelItemBuilder builder = new PanelItemBuilder();
        BentoBoxLocale language = this.plugin.getLocalesManager().getLanguages().get(locale);
        if (template.icon() != null) {
            builder.icon(template.icon().clone());
        } else {
            builder.icon(Objects.requireNonNullElseGet(language.getBanner(), () -> new ItemStack(Material.WHITE_BANNER, 1)));
        }
        if (template.title() != null) {
            builder.name(this.user.getTranslation(this.command.getWorld(), template.title(), "[name]", WordUtils.capitalize((String)locale.getDisplayName(this.user.getLocale()))));
        } else {
            builder.name(this.user.getTranslation("panels.language.buttons.language.name", "[name]", WordUtils.capitalize((String)locale.getDisplayName(this.user.getLocale()))));
        }
        StringBuilder authors = new StringBuilder();
        authors.append(this.user.getTranslation("panels.language.buttons.language.authors", new String[0]));
        for (String author : language.getAuthors()) {
            authors.append("\n").append(this.user.getTranslation("panels.language.buttons.language.author", "[name]", author));
        }
        StringBuilder selected = new StringBuilder();
        if (this.user.getLocale().equals(locale)) {
            selected.append(this.user.getTranslation("panels.language.buttons.language.selected", new String[0]));
        }
        String descriptionText = template.description() != null ? this.user.getTranslationOrNothing(template.description(), "[authors]", authors.toString(), "[selected]", selected.toString()) : this.user.getTranslationOrNothing("panels.language.buttons.language.description", "[authors]", authors.toString(), "[selected]", selected.toString());
        descriptionText = descriptionText.replaceAll("(?m)^[ \\t]*\\r?\\n", "").replaceAll("(?<!\\\\)\\|", "\n").replaceAll("\\\\\\|", "|");
        builder.description(descriptionText);
        List<ItemTemplateRecord.ActionRecords> actions = template.actions().stream().filter(action -> !this.user.getLocale().equals(locale) && ("SELECT".equalsIgnoreCase(action.actionType()) || "COMMANDS".equalsIgnoreCase(action.actionType()))).toList();
        builder.clickHandler((panel, user, clickType, i) -> {
            actions.forEach(action -> {
                if (clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) {
                    if ("SELECT".equalsIgnoreCase(action.actionType())) {
                        this.plugin.getPlayers().setLocale(this.user.getUniqueId(), locale.toLanguageTag());
                        this.user.sendMessage("panels.language.edited", "[lang]", WordUtils.capitalize((String)locale.getDisplayName(this.user.getLocale())));
                        this.build();
                    } else if ("COMMANDS".equalsIgnoreCase(action.actionType())) {
                        Util.runCommands(user, Arrays.stream(action.content().replaceAll(Pattern.quote("[label]"), this.command.getTopLabel()).split("\n")).toList(), "CHANGE_LOCALE_COMMANDS");
                    }
                }
            });
            return true;
        });
        List tooltips = actions.stream().filter(action -> action.tooltip() != null).map(action -> this.user.getTranslation(this.command.getWorld(), action.tooltip(), new String[0])).filter(text -> !text.isBlank()).collect(Collectors.toCollection(() -> new ArrayList(actions.size())));
        if (!tooltips.isEmpty()) {
            builder.description("");
            builder.description(tooltips);
        }
        return builder.build();
    }
}

