/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.panels.customizable;

import java.io.File;
import org.bukkit.event.inventory.ClickType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.panels.PanelItem;
import world.bentobox.bentobox.api.panels.TemplatedPanel;
import world.bentobox.bentobox.api.panels.reader.ItemTemplateRecord;
import world.bentobox.bentobox.api.user.User;

public abstract class AbstractPanel {
    public static final String LOCALE = "LOCALE";
    public static final String PREVIOUS = "PREVIOUS";
    public static final String NEXT = "NEXT";
    public static final String INDEXING = "indexing";
    public static final String SELECT_ACTION = "SELECT";
    public static final String COMMANDS_ACTION = "COMMANDS";
    public static final String AUTHORS = "[authors]";
    public static final String SELECTED = "[selected]";
    final BentoBox plugin;
    final CompositeCommand command;
    final User user;
    String mainLabel;
    int pageIndex;

    public AbstractPanel(CompositeCommand command, User user) {
        this.plugin = command.getPlugin();
        this.command = command;
        this.user = user;
        this.pageIndex = 0;
    }

    protected abstract PanelItem createNextButton(ItemTemplateRecord var1, TemplatedPanel.ItemSlot var2);

    protected abstract PanelItem createPreviousButton(ItemTemplateRecord var1, TemplatedPanel.ItemSlot var2);

    protected abstract void build();

    protected boolean hasNextPage(int elementListSize, int itemsPerPage) {
        return (this.pageIndex + 1) * itemsPerPage < elementListSize;
    }

    protected boolean hasPreviousPage() {
        return this.pageIndex > 0;
    }

    protected boolean handlePageChange(ItemTemplateRecord.ActionRecords action, ClickType clickType, String actionType) {
        if ((clickType == action.clickType() || action.clickType() == ClickType.UNKNOWN) && actionType.equalsIgnoreCase(action.actionType())) {
            if (actionType.equalsIgnoreCase(NEXT)) {
                ++this.pageIndex;
            } else if (actionType.equalsIgnoreCase(PREVIOUS)) {
                --this.pageIndex;
            }
            this.build();
            return true;
        }
        return false;
    }

    protected boolean doesCustomPanelExists(GameModeAddon addon, String name) {
        return addon.getDataFolder().exists() && new File(addon.getDataFolder(), "panels").exists() && new File(addon.getDataFolder(), "panels" + File.separator + name + ".yml").exists();
    }
}

